<?php $bg = $this->Url->image('login/background.jpg'); ?>

<?php
/**
 * Layout: default
 */

$identity = $this->request->getAttribute('identity');
$isAdmin  = $identity && strtolower((string)($identity->get('role') ?? '')) === 'admin';

use Cake\ORM\TableRegistry;

$RoleFeatureSettings = TableRegistry::getTableLocator()->get('RoleFeatureSettings');
$featureMap = $RoleFeatureSettings->getVisibleMapForRole($isAdmin ? 'admin' : 'clinician');

$featureVisible = function (string $key) use ($featureMap): bool {
    return !empty($featureMap[$key]);
};

$fullName = 'User';
if ($identity) {
    $first = trim((string)($identity->get('first_name') ?? ''));
    $last  = trim((string)($identity->get('last_name') ?? ''));
    $fullName = trim($first . ' ' . $last) ?: (string)($identity->get('email') ?? 'User');
}

$canWaitlist  = true;
$canBilling   = $isAdmin || (bool)($identity->get('can_billing')   ?? false);
$canContacts  = $isAdmin || (bool)($identity->get('can_contacts')  ?? false);
$canMarketing = $isAdmin || (bool)($identity->get('can_marketing') ?? false);
$canProducts  = $isAdmin || (bool)($identity->get('can_products')  ?? false);
$canReports   = $isAdmin || (bool)($identity->get('can_reports')   ?? false);

$badgeParticipants = (int)($this->get('participantsBadge') ?? 0);

$currentController = $this->request->getParam('controller');
$currentAction     = $this->request->getParam('action');
$currentUrl        = $this->request->getRequestTarget();

$onboardingState = null;
if ($isAdmin) {
    // read from session; if missing, try to warm it via helper
    $clinicId = $this->getRequest()->getSession()->read('Current.clinic_id');
    if ($clinicId === null && method_exists($this, 'currentClinicId')) {
        $clinicId = $this->currentClinicId();
    }

    if ($clinicId !== null) {
        $OnboardingStates = TableRegistry::getTableLocator()->get('OnboardingStates');
        $onboardingState  = $OnboardingStates->find()
            ->where(['clinic_id' => (int)$clinicId, 'dismissed' => 0])
            ->first();
    }
}

$avatarSrc = $this->Url->build('/img/default-avatar.png');
if ($identity) {
    $uid = (int)$identity->getIdentifier();
    if ($uid > 0) {
        $base  = WWW_ROOT . 'uploads' . DS . 'avatars' . DS . $uid . DS;
        $found = null;
        foreach (['jpg','png','webp','gif'] as $e) {
            $p = $base . 'avatar.' . $e;
            if (file_exists($p)) {
                $found = ['path' => $p, 'ext' => $e];
                break;
            }
        }
        if ($found) {
            $rel = '/uploads/avatars/' . $uid . '/avatar.' . $found['ext'];
            $avatarSrc = $this->Url->build($rel) . '?t=' . filemtime($found['path']);
        }
    }
}

$clinicName = 'Co-Linic AI';
try {
    $clinicId = $this->getRequest()->getSession()->read('Current.clinic_id');
    if ($clinicId === null && method_exists($this, 'currentClinicId')) {
        $clinicId = $this->currentClinicId();
    }
    if ($clinicId) {
        $Clinics = \Cake\ORM\TableRegistry::getTableLocator()->get('Clinics');
        $row = $Clinics->find()->select(['name'])->where(['id' => (int)$clinicId])->first();
        if ($row && trim((string)$row->name) !== '') {
            $clinicName = (string)$row->name;
        }
    }
} catch (\Throwable $e) { /* swallow */ }
?>
<style>
    :root{
        --ns-h: clamp(36px, 4.5vw, 44px);
        --ns-br: 999px;
    }

    .ns-search{
        position: relative;
        display: block;
        flex: 0 1 clamp(240px, 42vw, 520px);
        width: clamp(240px, 42vw, 520px);
        max-width: 56vw;
        min-width: 220px;
    }

    .ns-input{
        display: block;
        width: 100%;
        height: var(--ns-h);
        padding: 0 12px;
        padding-right: calc(var(--ns-h) + 8px);
        border-radius: var(--ns-br);
        line-height: 1.2;
        -webkit-appearance: none;
    }

    .ns-btn{
        position: absolute; right: 4px; top: 50%; transform: translateY(-50%);
        width: calc(var(--ns-h) - 8px); height: calc(var(--ns-h) - 8px);
        padding: 0; border-radius: 50%;
        display: inline-flex; align-items: center; justify-content: center;
    }
    .ns-btn i{ font-size: 1.05rem; line-height: 1; }

    ul.ui-autocomplete.ns-menu{
        position: fixed !important;
        z-index: 4000 !important;
        box-sizing: border-box;
        margin-top: 6px !important;
        background: #fff !important;
        border: 1px solid #e5e7eb !important;
        border-radius: 12px !important;
        box-shadow: 0 10px 24px rgba(16,24,40,.12) !important;
        max-height: 320px !important;
        overflow-y: auto !important;
        padding: 8px !important;
        width: auto !important;
        min-width: clamp(360px, 42vw, 520px) !important;
        max-width: calc(100vw - 24px) !important;
    }

    .ns-item{
        display: grid; grid-template-columns: 36px 1fr auto;
        gap: 10px; align-items: center;
        padding: 10px 12px; border-radius: 10px;
    }
    .ns-item:hover{ background: #f8fafc; }
    .ns-ava{
        width:36px; height:36px; border-radius:50%;
        background:#eef2ff; color:#4f46e5; font-weight:700;
        display:flex; align-items:center; justify-content:center; font-size:14px;
    }
    .ns-text{ min-width: 0; }
    .ns-row1{
        display:flex; gap:8px; align-items:center;
        font-size:14px; line-height:1.2; color:#111827; font-weight:600;
        white-space:nowrap; overflow:hidden; text-overflow:ellipsis;
    }
    .ns-phone{
        font-weight:500; color:#374151; opacity:.9;
        white-space:nowrap; overflow:hidden; text-overflow:ellipsis;
    }
    .ns-row2{
        margin-top:2px; font-size:12px; color:#6b7280;
        white-space:nowrap; overflow:hidden; text-overflow:ellipsis;
    }
    .ns-meta{ display:flex; gap:6px; flex-wrap:wrap; justify-self:end; }
    .ns-chip{
        background:#f3f4f6; color:#111827; border-radius:999px;
        padding:4px 8px; font-size:11px; line-height:1;
    }
    .ns-empty{
        padding: 10px 12px; border-radius: 8px; background: #f8fafc;
        color:#64748b; text-align:center; font-size:13px;
    }

    .ns-menu mark{ background:#fff3bf; color:inherit; padding:0 2px; border-radius:3px; }

    @media (max-width: 992px){
        .ns-search{ flex: 1 1 auto; width: 100%; max-width: none; }
    }
    @media (max-width: 576px){
        :root{ --ns-h: 40px; }
        .ns-search{ width: calc(100vw - 110px); }
    }

    .ns-input{
        border: 1px solid #e5e7eb;
        background: #fff;
        outline: none;
        transition: box-shadow .15s, border-color .15s;
        -webkit-tap-highlight-color: transparent;
    }
    .ns-input:focus{
        border-color: #c7d2fe;
        box-shadow: 0 0 0 3px rgba(99,102,241,.18);
    }

    @media (max-width: 576px){

        :root{ --ns-h: 44px; }
        .main-navbar{ padding: 10px 12px; }

        .ns-search{
            width: 100%;
            max-width: none;
            flex: 1 1 auto;
            margin: 0;
        }
        .ns-input{
            font-size: 15px;
            padding-left: 14px;
            padding-right: 50px;
            border-radius: 24px;
        }
        .ns-btn{
            right: 6px;
            width: 40px;
            height: 40px;
        }
        .ns-btn i{ font-size: 1rem; }

        ul.ui-autocomplete.ns-menu{
            min-width: calc(100vw - 24px) !important;
            max-width: calc(100vw - 24px) !important;
            padding: 6px !important;
        }

        .ns-item{
            grid-template-columns: 32px 1fr auto;
            gap: 8px;
            padding: 8px 10px;
            border-radius: 8px;
        }
        .ns-ava{
            width: 32px; height: 32px; font-size: 13px;
        }
        .ns-row1{ font-size: 13px; }
        .ns-row2{ font-size: 12px; }
        .ns-phone{ font-size: 12px; }

        .ns-meta{ gap: 4px; }
        .ns-chip{
            padding: 2px 6px;
            font-size: 10.5px;
            line-height: 1.1;
        }

        .ns-menu mark{ background: #fff7cc; }
    }

    @media (min-width: 577px) and (max-width: 768px){

        :root{ --ns-h: 42px; }
        .main-navbar{ padding: 12px 16px; }

        .ns-search{
            flex: 1 1 auto;
            width: 100%;
            max-width: none;
        }
        .ns-input{
            font-size: 14px;
            padding-right: 52px;
            border-radius: 22px;
        }
        .ns-btn{ width: 38px; height: 38px; right: 8px; }
        .ns-btn i{ font-size: 1.05rem; }

        ul.ui-autocomplete.ns-menu{
            min-width: clamp(360px, 70vw, 560px) !important;
            max-width: calc(100vw - 24px) !important;
            padding: 8px !important;
        }

        .ns-item{ padding: 9px 12px; gap: 10px; }
        .ns-ava{ width: 34px; height: 34px; }
        .ns-row1{ font-size: 14px; }
    }

    @media (prefers-color-scheme: dark){
        .ns-input{
            background: #111827;
            color: #e5e7eb;
            border-color: #374151;
        }
        .ns-input::placeholder{ color: #9ca3af; }
        ul.ui-autocomplete.ns-menu{
            background: #0f172a !important;
            border-color: #334155 !important;
            box-shadow: 0 10px 24px rgba(0,0,0,.35) !important;
        }
        .ns-item:hover{ background: rgba(148,163,184,.12); }
        .ns-chip{ background:#1f2937; color:#e5e7eb; }
    }
    .global-bg{
        position: fixed;
        inset: 0;
        background: url('<?= h($bg) ?>') center / cover no-repeat fixed;
        opacity: .28;
        filter: contrast(1.08) saturate(1.05);
        pointer-events: none;
        z-index: 0;
    }
    .main-wrapper{
        position: relative;
        z-index: 1;
    }

    @media (prefers-color-scheme: dark){
        .global-bg{ opacity: .14; filter: contrast(1.05) saturate(1.0); }
    }

</style>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title><?= h($clinicName) ?> - Admin Dashboard</title>
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/intro.js/minified/introjs.min.css" rel="stylesheet">

    <?= $this->Html->meta('icon', $this->Url->build('/img/favicon.ico'), ['type' => 'image/x-icon']) ?>

    <?= $this->Html->css('/css/app.min.css') ?>
    <?= $this->Html->css('/bundles/jqvmap/dist/jqvmap.min.css') ?>
    <?= $this->Html->css('/bundles/weather-icon/css/weather-icons.min.css') ?>
    <?= $this->Html->css('/bundles/weather-icon/css/weather-icons-wind.min.css') ?>
    <?= $this->Html->css('/bundles/summernote/summernote-bs4.css') ?>
    <?= $this->Html->css('/css/style.css') ?>
    <?= $this->Html->css('/css/components.css') ?>
    <?= $this->Html->css('/css/custom.css') ?>
    <?= $this->Html->css('clinician_profile') ?>

    <?= $this->fetch('css') ?>
    <?= $this->fetch('meta') ?>
</head>

<body>
<div class="global-bg"></div>
<div class="loader"></div>
<div id="app">
    <div class="main-wrapper main-wrapper-1">

        <div class="navbar-bg"></div>

        <nav class="navbar navbar-expand-lg main-navbar">
            <div class="form-inline mr-auto">
                <ul class="navbar-nav mr-3">
                    <li>
                        <a href="#" data-toggle="sidebar" class="nav-link nav-link-lg collapse-btn">
                            <i data-feather="align-justify"></i>
                        </a>
                    </li>
                    <li>
                        <a href="#" class="nav-link nav-link-lg fullscreen-btn">
                            <i data-feather="maximize"></i>
                        </a>
                    </li>
                    <li>
                        <form class="form-inline mr-auto" onsubmit="return false;">
                            <div class="ns-search">
                                <input id="participant-search" class="ns-input" type="text"
                                       placeholder="Search participants" autocomplete="off"
                                       data-intro="Search for participants here."
                                       data-title="Search" data-step="5">
                                <button class="ns-btn" type="submit"><i class="fas fa-search"></i></button>
                            </div>
                        </form>
                    </li>
                </ul>
            </div>
            <ul class="navbar-nav navbar-right">
                <?php if ($isAdmin && $onboardingState) : ?>
                    <?php
                    $done    = (int)$onboardingState->step1_done + (int)$onboardingState->step2_done
                        + (int)$onboardingState->step3_done + (int)$onboardingState->step4_done;
                    $percent = (int)round($done * 25);
                    ?>
                    <li class="nav-item d-flex align-items-center mr-3">
                        <a href="#" id="onboarding-link" class="d-flex align-items-center" role="button" aria-haspopup="dialog" aria-controls="onboardingModal"
                           <?php if ($isAdmin): ?>
                               data-intro="You can further customise your clinic specific settings here. e.g. Clinic location and services."
                               data-title="Clinic"
                               data-step="6"
                           <?php endif; ?>
                        >
                            Get Started
                            <span class="ml-2"><?= $percent ?>%</span>
                        </a>
                    </li>
                <?php endif; ?>
                <li class="dropdown">
                    <a href="#" data-toggle="dropdown" class="nav-link dropdown-toggle nav-link-lg nav-link-user">
                        <img alt="image" src="<?= h($avatarSrc) ?>" class="user-img-radious-style">
                        <span class="d-sm-none d-lg-inline-block"></span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right pullDown">
                        <div class="dropdown-title">Hello <?= h($fullName) ?></div>
                        <a href="<?= $this->Url->build('/clinician-profile') ?>" class="dropdown-item has-icon">
                            <i class="far fa-user"></i> Profile
                        </a>
                        <div class="dropdown-divider"></div>
                        <a href="<?= $this->Url->build('/logout') ?>" class="dropdown-item has-icon text-danger">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </div>
                </li>

            </ul>
        </nav>

        <div class="main-sidebar sidebar-style-2">
            <aside id="sidebar-wrapper">
                <div class="sidebar-brand">
                    <a href="<?= $this->Url->build('/dashboard') ?>">
                        <img alt="image" src="<?= $this->Url->image('TP/logo.png') ?>" class="header-logo" />
                        <span class="logo-name"><?= h($clinicName) ?></span>
                    </a>
                </div>
                <div class="sidebar-user">
                    <div class="sidebar-user-picture">
                        <a href="<?= $this->Url->build('/clinician-profile') ?>">
                            <img alt="image" src="<?= h($avatarSrc) ?>">
                        </a>
                    </div>
                    <div class="sidebar-user-details">
                        <div class="user-name"><?= h($fullName) ?></div>
                        <?php if ($isAdmin) : ?>
                            <div class="user-role">Admin</div>
                        <?php else : ?>
                            <div class="user-role">Clinician</div>
                        <?php endif; ?>
                    </div>
                </div>
                <ul class="sidebar-menu">

                    <?php if (!$isAdmin) : ?>
                        <li class="menu-header">Clinician Profile</li>
                        <li class="dropdown <?php if (strtolower($currentAction) == 'index' || strtolower($currentAction) == 'profile' || strtolower($currentUrl) === '/clinicians') {
                            echo 'active"';
                                            } ?>"  href="<?= $this->Url->build('/clinician-profile') ?>">
                            <a href="#" class="nav-link has-dropdown"><i data-feather="user"></i><span>My Profile</span></a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a class="nav-link"
                                        <?php if (strtolower($currentAction) == 'profile' || strtolower($currentUrl) === '/clinician-profile') {
                                            echo 'id="current-page"';
                                        } ?>
                                       href="<?= $this->Url->build('/clinician-profile') ?>">
                                        My Details
                                    </a>
                                </li>
                                <li><a class="nav-link" <?php if (strtolower($currentAction) == 'index' && strtolower($currentUrl) === '/clinicians') {
                                    echo 'id="current-page"';
                                                        } ?> href="<?= $this->Url->build('/clinicians') ?>">All Clinicians</a></li>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if ($featureVisible('calendar')) : ?>
                        <li class="menu-header">Menu</li>

                        <li <?php if (strtolower($currentController) === 'calendar' && strtolower($currentAction) === 'index') {
                            echo 'id="current-page"';
                            } ?>
                            data-intro="This is your calendar. You can view and manage all appointments here."
                            data-title="Calendar"
                            data-step="1"
                        >
                            <a class="nav-link" href="<?= $this->Url->build(['controller' => 'Calendar', 'action' => 'index']) ?>">
                                <i data-feather="calendar"></i><span>Calendar</span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if (!empty($isAdmin) && $isAdmin) : ?>
                        <li class="menu-header">Admin</li>
                        <li class="dropdown <?php if (strtolower($currentController) === 'clinicianregister' && strtolower($currentAction) === 'index' || strtolower($currentUrl) === '/clinicians') {
                            echo 'active';
                                            } ?>"
                            data-intro="As an admin, you can manage all clinicians here."
                            data-title="Clinician"
                            data-step="2">
                            <a href="#" class="nav-link has-dropdown"><i data-feather="clipboard"></i><span>Clinicians</span></a>
                            <ul class="dropdown-menu" >
                                <li>
                                    <a class="nav-link" <?php if (strtolower($currentController) === 'clinicianregister') {
                                        echo 'id="current-page"';
                                                        } ?> href="<?= $this->Url->build(['controller' => 'ClinicianRegister', 'action' => 'index']) ?>">
                                        Add New Clinician
                                    </a>
                                </li>
                                <li><a class="nav-link" <?php if (strtolower($currentController) === 'clinician' && strtolower($currentUrl) === '/clinicians') {
                                    echo 'id="current-page"';
                                                        } ?> href="<?= $this->Url->build('/clinicians') ?>">All Clinicians</a></li>
                            </ul>

                        <li class="dropdown <?php if ((strtolower($currentAction) === 'profile' || strtolower($currentAction) === 'new')) {
                            echo 'active';
                                            } ?>"
                            data-intro="View your admin profile, or create new admin accounts."
                            data-title="Administrator"
                            data-step="3">
                            <a href="#" class="nav-link has-dropdown"><i data-feather="clipboard"></i><span>Admin</span></a>
                            <ul class="dropdown-menu" >
                                <li>
                                    <a class="nav-link" <?php if (strtolower($currentController) === 'login' && strtolower($currentAction) === 'new') {
                                        echo 'id="current-page"';
                                                        } ?> href="<?= $this->Url->build('/login/new') ?>">
                                        Add New Admin
                                    </a>
                                </li>
                                <li><a class="nav-link" <?php if (strtolower($currentAction) == 'profile') {
                                    echo 'id="current-page"';
                                                        } ?> href="<?= $this->Url->build('/clinician-profile') ?>">View Admin</a></li>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if ($featureVisible('participants')) : ?>
                        <li class="menu-header">Participants</li>
                        <li class="dropdown <?php if (strtolower($currentController) === 'participants') {
                            echo 'active';
                                            } ?>"
                            data-intro="This is your Participant list. You can view and manage all participants here."
                            data-title="Participants"
                            data-step="4">
                            <a href="#" class="nav-link has-dropdown">
                                <i data-feather="users"></i>
                                <span>Participants</span>
                                <?php if ($badgeParticipants > 0) : ?>
                                    <span class="badge badge-info" style="margin-left:6px;"><?= $badgeParticipants ?></span>
                                <?php endif; ?>
                            </a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a class="nav-link" <?php if (strtolower($currentController) === 'participants' && strtolower($currentAction) === 'add') {
                                        echo 'id=current-page';
                                                        } ?> href="<?= $this->Url->build(['controller' => 'Participants', 'action' => 'add']) ?>">
                                        Add New Participant
                                    </a>
                                </li>
                                <li>
                                    <a class="nav-link" <?php if (strtolower($currentController) === 'participants' && strtolower($currentAction) === 'index') {
                                        echo 'id=current-page';
                                                        } ?> href="<?= $this->Url->build(['controller' => 'Participants', 'action' => 'index']) ?>">
                                        All Participants
                                    </a>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if ($featureVisible('waitlist') && $canWaitlist) : ?>
                        <li>
                            <a class="nav-link" <?php if (strtolower($currentController) === 'waitlist') {
                                echo 'id="current-page"';
                                                } ?>  href="<?= $this->Url->build(['controller' => 'Waitlist','action' => 'index']) ?>">
                                <i data-feather="list"></i><span>Waitlist</span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <li class="menu-header">Settings</li>
                    <li class="dropdown" >
                        <a href="#" class="nav-link has-dropdown <?php if (strtolower($currentController) === 'settings') {
                            echo 'active';
                                                                 } ?>">
                            <i data-feather="settings"></i><span>Settings</span>
                        </a>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="nav-link" <?php if (strtolower($currentController) === 'settings') {
                                    echo 'id="current-page"';
                                                    } ?> href="<?= $this->Url->build(['controller' => 'Settings','action' => 'index']) ?>">
                                    <span>System Features</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <a class="nav-link" href="#" id="show-tour" class="menu-header mt-2 mb-2"><i data-feather="help-circle"></i>
                            <span>User Tour</span>
                        </a>
                    </li>

                </ul>

            </aside>
        </div>

        <div class="main-content">
            <?= $this->Flash->render() ?>
            <?= $this->fetch('content') ?>

            <div class="settingSidebar">
                <a href="javascript:void(0)" class="settingPanelToggle">
                    <i class="fa fa-spin fa-cog"></i>
                </a>
                <div class="settingSidebar-body ps-container ps-theme-default">
                    <div class="fade show active">
                        <div class="setting-panel-header">Setting Panel</div>

                        <div class="p-15 border-bottom">
                            <h6 class="font-medium m-b-10">Select Layout</h6>
                            <div class="selectgroup layout-color w-50">
                                <label class="selectgroup-item">
                                    <input type="radio" name="value" value="1" class="selectgroup-input select-layout" checked>
                                    <span class="selectgroup-button">Light</span>
                                </label>
                                <label class="selectgroup-item">
                                    <input type="radio" name="value" value="2" class="selectgroup-input select-layout">
                                    <span class="selectgroup-button">Dark</span>
                                </label>
                            </div>
                        </div>

                        <div class="p-15 border-bottom">
                            <h6 class="font-medium m-b-10">Sidebar Color</h6>
                            <div class="selectgroup selectgroup-pills sidebar-color">
                                <label class="selectgroup-item">
                                    <input type="radio" name="icon-input" value="1" class="selectgroup-input select-sidebar">
                                    <span class="selectgroup-button selectgroup-button-icon" data-toggle="tooltip"
                                          data-original-title="Light Sidebar"><i class="fas fa-sun"></i></span>
                                </label>
                                <label class="selectgroup-item">
                                    <input type="radio" name="icon-input" value="2" class="selectgroup-input select-sidebar" checked>
                                    <span class="selectgroup-button selectgroup-button-icon" data-toggle="tooltip"
                                          data-original-title="Dark Sidebar"><i class="fas fa-moon"></i></span>
                                </label>
                            </div>
                        </div>

                        <div class="p-15 border-bottom">
                            <h6 class="font-medium m-b-10">Color Theme</h6>
                            <div class="theme-setting-options">
                                <ul class="choose-theme list-unstyled mb-0">
                                    <li title="white" class="active"><div class="white"></div></li>
                                    <li title="cyan"><div class="cyan"></div></li>
                                    <li title="black"><div class="black"></div></li>
                                    <li title="purple"><div class="purple"></div></li>
                                    <li title="orange"><div class="orange"></div></li>
                                    <li title="green"><div class="green"></div></li>
                                    <li title="red"><div class="red"></div></li>
                                </ul>
                            </div>
                        </div>

                        <div class="p-15 border-bottom">
                            <div class="theme-setting-options">
                                <label>
                                    <span class="control-label p-r-20">Mini Sidebar</span>
                                    <input type="checkbox" name="custom-switch-checkbox" class="custom-switch-input" id="mini_sidebar_setting">
                                    <span class="custom-switch-indicator"></span>
                                </label>
                            </div>
                        </div>

                        <div class="mt-4 mb-4 p-3 align-center rt-sidebar-last-ele">
                            <a href="#" class="btn btn-icon icon-left btn-primary btn-restore-theme">
                                <i class="fas fa-undo"></i> Restore Default
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<div class="modal fade confirm-modal" id="appConfirm" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header align-items-center">
                <div class="confirm-icon mr-2"><i class="fas fa-exclamation-triangle"></i></div>
                <h5 class="modal-title" id="appConfirmTitle">Please Confirm</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>×</span></button>
            </div>
            <div class="modal-body">
                <p id="appConfirmMsg" class="mb-0">Are you sure?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal" id="appConfirmCancel">Cancel</button>
                <button type="button" class="btn btn-danger" id="appConfirmOk">OK</button>
            </div>
        </div>
    </div>
</div>

<div id="onboardingModal" class="modal fade" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Onboarding</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>×</span></button>
            </div>
            <div id="onboardingModalBody" class="modal-body">
                <div class="text-center p-4">Loading…</div>
            </div>
        </div>
    </div>
</div>

<?= $this->Html->script('/js/app.min.js') ?>
<?= $this->Html->script('/bundles/echart/echarts.js') ?>
<?= $this->Html->script('/bundles/chartjs/chart.min.js') ?>
<?= $this->Html->script('/js/page/index.js') ?>
<?= $this->Html->script('/js/scripts.js') ?>
<?= $this->Html->script('/js/custom.js') ?>

<!-- jQuery UI JS (after jQuery, before your scripts) -->
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

<script>
    (function(){
        const $input = $("#participant-search");

        function positionMenu() {
            const $menu = $input.autocomplete("widget");
            $menu.addClass("ns-menu");

            const rect   = $input[0].getBoundingClientRect();
            const gutter = 12;
            const vw     = window.innerWidth;

            let w = Math.min(rect.width, vw - gutter * 2);
            let left = rect.left;
            let top  = rect.bottom + 6;

            const roomRight = vw - gutter - left;
            if (w > roomRight) {
                w = Math.min(w, vw - gutter * 2);
                left = Math.max(gutter, vw - gutter - w);
            }
            if (left < gutter) left = gutter;

            $menu.css({ position: "fixed", width: w, left, top });
        }

        $input.autocomplete({
            appendTo: "body",
            minLength: 1,
            delay: 120,
            source: function(request, response){
                $.getJSON("<?= $this->Url->build('/participants/search') ?>", { q: request.term })
                    .done(function(data){
                        const arr = (data && data.results) ? data.results : [];
                        response(arr.length ? arr : [{ _empty:true, label:'No results' }]);
                    });
            },
            open: positionMenu,
            response: positionMenu,
            search: positionMenu,
            resize: positionMenu,
            select: function(e, ui){
                if (ui.item && !ui.item._empty && ui.item.id) {
                    window.location.assign(<?= json_encode($this->Url->build('/participants/dashboard/')) ?> + ui.item.id);
                }
                return false;
            }
        });

        $(window).on('scroll resize', positionMenu);

        const inst = $input.autocomplete("instance");
        if (inst){
            const esc = s => $('<div>').text(String(s||'')).html();
            const ell = (s, n) => (s && s.length > n) ? (s.slice(0, n-1) + '…') : s;
            const maskPhone = s => String(s||'').replace(/(\d{3})\d{3,4}(\d{2,})/, '$1****$2');
            const hi = (text, term) => {
                if (!text || !term) return esc(text);
                try{
                    const re = new RegExp('(' + term.replace(/[.*+?^${}()|[\]\\]/g,'\\$&') + ')','ig');
                    return esc(text).replace(re,'<mark>$1</mark>');
                }catch(_){ return esc(text); }
            };

            inst._renderItem = function(ul, item){
                if (item._empty){
                    return $("<li>").append(`<div class="ns-empty">No results</div>`).appendTo(ul);
                }
                const term   = ($input.val()||'').trim();
                const name   = item.name || item.label || '';
                const phone  = item.phone ? maskPhone(item.phone) : '';
                const email  = item.email || '';
                const ini    = (item.initial || (name||'U')[0]).toString().toUpperCase();
                const dob    = item.dob_fmt || '';
                const age    = item.age || '';
                const gender = item.gender || '';

                const chips = [];
                if (age)    chips.push(`<span class="ns-chip">${esc(age)}</span>`);
                if (gender) chips.push(`<span class="ns-chip">${esc(gender)}</span>`);
                if (chips.length < 2 && dob) chips.push(`<span class="ns-chip">${esc(dob)}</span>`);

                const html = `
        <div class="ns-item">
          <div class="ns-ava">${esc(ini[0] || 'U')}</div>
          <div class="ns-text">
            <div class="ns-row1">
              <span class="ns-name">${hi(ell(name, 28), term)}</span>
              ${phone ? `<span class="ns-phone">${hi(ell(phone, 18), term)}</span>` : ``}
            </div>
            ${email ? `<div class="ns-row2">${hi(ell(email, 40), term)}</div>` : ``}
          </div>
          ${chips.length ? `<div class="ns-meta">${chips.join('')}</div>` : `<div></div>`}
        </div>`;
                return $("<li>").append(html).appendTo(ul);
            };

            inst._renderMenu = function(ul, items){
                $(ul).addClass("ns-menu");
                for (let i=0;i<items.length;i++) this._renderItemData(ul, items[i]);
            };
        }
    })();
</script>

<script>
    (function(){
        let targetFormId = null;
        const $modal = $('#appConfirm');
        const $title = $('#appConfirmTitle');
        const $msg   = $('#appConfirmMsg');
        const $ok    = $('#appConfirmOk');
        const $cancel= $('#appConfirmCancel');

        $(document).on('click', '.js-confirm', function(e){
            e.preventDefault();
            const $el = $(this);
            targetFormId = $el.data('form');
            $title.text($el.data('title') || 'Please Confirm');
            $msg.text($el.data('message') || 'Are you sure?');
            $ok.text($el.data('ok-text') || 'OK')
                .removeClass('btn-danger btn-primary btn-warning btn-success')
                .addClass($el.data('ok-class') || 'btn-primary');
            $cancel.text($el.data('cancel-text') || 'Cancel');
            $modal.modal('show');
        });

        $ok.on('click', function(){
            if (targetFormId) {
                const form = document.getElementById(targetFormId);
                if (form) form.submit();
                targetFormId = null;
            }
            $modal.modal('hide');
        });

        $modal.on('hidden.bs.modal', function(){ targetFormId = null; });
    })();
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // ===== Open modal =====
        const trigger = document.getElementById('onboarding-link');
        if (trigger) {
            const $modal = $('#onboardingModal');
            const $body  = $('#onboardingModalBody');

            window.openOnboardingModal = function openOnboardingModal() {
                $body.html('<div class="text-center p-4">Loading…</div>');
                $.ajax({
                    url: '<?= $this->Url->build(["controller"=>"Onboarding","action"=>"modal"]) ?>',
                    method: 'GET',
                    headers: { 'X-Requested-With': 'XMLHttpRequest' }
                }).done(function (html) {
                    $body.html(html);
                }).fail(function (xhr) {
                    const msg = (xhr.responseText || 'Failed to load.').toString();
                    $body.html('<div class="text-danger p-3">Error ' + xhr.status + ': ' + msg + '</div>');
                    console.error('Onboarding modal failed:', xhr);
                });
                $modal.modal('show');
            };

            trigger.addEventListener('click', function (e) {
                e.preventDefault();
                openOnboardingModal();
            });
        }

        // ---------- helpers ----------
        function setName(el, name) { if (el) el.setAttribute('name', name); }

        // find input by flat OR array-style name inside a container
        function findInput(container, field) {
            return container.querySelector(
                `[name="${field}"], [name$="[${field}]"]`
            );
        }

        // ---------- locations ----------
        function reindexLocations() {
            // primary -> locations[0][...]
            const primary = document.querySelector('.onb-location--primary');
            if (primary) {
                setName(findInput(primary, 'address_street'),   'locations[0][address_street]');
                setName(findInput(primary, 'address_suburb'),   'locations[0][address_suburb]');
                setName(findInput(primary, 'address_state'),    'locations[0][address_state]');
                setName(findInput(primary, 'address_postcode'), 'locations[0][address_postcode]');
                setName(findInput(primary, 'address_country'),  'locations[0][address_country]');
            }

            // additional: contiguous 1..n
            const extras = document.querySelectorAll('#onb-locations .onb-location');
            extras.forEach((wrap, idx) => {
                const i = idx + 1;
                setName(findInput(wrap, 'address_street'),   `locations[${i}][address_street]`);
                setName(findInput(wrap, 'address_suburb'),   `locations[${i}][address_suburb]`);
                setName(findInput(wrap, 'address_state'),    `locations[${i}][address_state]`);
                setName(findInput(wrap, 'address_postcode'), `locations[${i}][address_postcode]`);
                setName(findInput(wrap, 'address_country'),  `locations[${i}][address_country]`);
            });
        }

        function addLocation() {
            const wrap = document.getElementById('onb-locations');
            const tpl  = document.getElementById('tpl-onb-location').innerHTML;
            const div  = document.createElement('div');
            div.innerHTML = tpl.replace(/__IDX__/g, 'X'); // placeholder; we reindex next
            wrap.appendChild(div.firstElementChild);
            reindexLocations();
        }

        // ---------- phones ----------
        function reindexPhones() {
            const primaryInput = document.querySelector('.onb-phone--primary input');
            if (primaryInput) primaryInput.setAttribute('name', 'phones[0]');

            const extras = document.querySelectorAll('#onb-phones .onb-phone:not(.onb-phone--primary) input');
            extras.forEach((inp, idx) => inp.setAttribute('name', `phones[${idx + 1}]`));
        }

        function addPhone() {
            const wrap = document.getElementById('onb-phones');
            const tpl  = document.getElementById('tpl-onb-phone').innerHTML;
            const div  = document.createElement('div');
            div.innerHTML = tpl.replace(/__IDX__/g, 'X'); // placeholder; we reindex next
            wrap.appendChild(div.firstElementChild);
            reindexPhones();
        }

        // ---------- services ----------
        function reindexServices() {
            const rows = document.querySelectorAll('#onb-services .onb-service');
            rows.forEach((wrap, idx) => {
                wrap.querySelectorAll('input[name^="services["]').forEach(inp => {
                    // normalize to services[<idx>][field]
                    const field = (inp.name.match(/\[(name|code|duration_minutes|price_cents)\]/) || [,'name'])[1];
                    inp.name = `services[${idx}][${field}]`;
                });
            });
        }
        function addService() {
            const wrap = document.getElementById('onb-services');
            const tpl  = document.getElementById('tpl-onb-service').innerHTML;
            const div  = document.createElement('div');
            div.innerHTML = tpl.replace(/__IDX__/g, 'X');
            wrap.appendChild(div.firstElementChild);
            reindexServices();
        }

        // ---------- wizard nav inside modal ----------
        $(document).on('click', '.js-onb-open', function (e) {
            e.preventDefault();
            const $body  = $('#onboardingModalBody');
            const $sheet = $('#onb-sheet-bizinfo');
            if ($sheet.length) {
                $body.html($sheet.removeClass('d-none'));
                $('#onb-practice-section').removeClass('d-none');
                $('#onb-phone-section').addClass('d-none');
                $('#onb-alert').addClass('d-none').text('');
            }
        });

        $(document).on('click', '.js-onb-back', function () {
            $('#onboardingModalBody').load(
                '<?= $this->Url->build(["controller"=>"Onboarding","action"=>"modal"]) ?>'
            );
        });

        // Add / Remove buttons
        $(document).on('click', '#onb-add-location', function (e) { e.preventDefault(); addLocation(); });
        $(document).on('click', '#onb-add-phone',    function (e) { e.preventDefault(); addPhone(); });
        $(document).on('click', '.onb-remove-location', function (e) {
            e.preventDefault();
            $(this).closest('.onb-location').remove();
            reindexLocations();
        });
        $(document).on('click', '.onb-remove-phone', function (e) {
            e.preventDefault();
            $(this).closest('.onb-phone').remove();
            reindexPhones();
        });


        $(document).on('click', '.js-onb-next', async function () {
            try {
                reindexLocations();
                const form = document.getElementById('onb-form-practice');
                const data = new FormData(form);

                const res  = await fetch('<?= $this->Url->build("/onboarding/save-practice") ?>', {
                    method: 'POST',
                    headers: { 'X-CSRF-Token': '<?= $this->request->getAttribute("csrfToken") ?>' },
                    body: data
                });
                const json = await res.json();
                if (!res.ok || !json.ok) throw new Error(json.error || ('HTTP ' + res.status));

                const savedName = (json.business_name || '').trim();
                if (savedName) {
                    const logoEl = document.querySelector('.logo-name');
                    if (logoEl) logoEl.textContent = savedName;
                    document.title = savedName + ' - Admin Dashboard';
                }

                const nameInput = document.querySelector('#ob-biz-name');
                const clinicName = savedName || (nameInput ? nameInput.value.trim() : '');
                const bizLabel = document.querySelector('.onb-bizinfo-label');
                if (clinicName && bizLabel) {
                    bizLabel.innerHTML = `Business Information <small class="text-muted">(${clinicName})</small>`;
                }

                $('#onb-practice-section').addClass('d-none');
                $('#onb-phone-section').removeClass('d-none');
            } catch (e) {
                const $a = $('#onb-alert');
                $a.text('Could not save practice details. ' + e.message)
                    .removeClass('d-none')
                    .removeClass('alert-success')
                    .addClass('alert-danger');
                console.error(e);
            }
        });

        $(document).on('click', '.js-onb-prev', function (e) {
            e.preventDefault();
            $('#onb-phone-section').addClass('d-none');
            $('#onb-practice-section').removeClass('d-none');
            $('#onb-alert').addClass('d-none').text('');
        });

        // ---------- submit: Finish ----------
        $(document).on('click', '.js-onb-finish', async function () {
            try {
                reindexPhones();
                const form = document.getElementById('onb-form-phone');
                const data = new FormData(form);

                const res  = await fetch('<?= $this->Url->build("/onboarding/save-phone") ?>', {
                    method: 'POST',
                    headers: { 'X-CSRF-Token': '<?= $this->request->getAttribute("csrfToken") ?>' },
                    body: data
                });
                const json = await res.json();
                if (!res.ok || !json.ok) throw new Error(json.error || ('HTTP ' + res.status));

                await fetch('<?= $this->Url->build("/onboarding/complete/1") ?>', { method: 'GET' });
                $('#onboardingModalBody').load('<?= $this->Url->build(["controller"=>"Onboarding","action"=>"modal"]) ?>');
            } catch (e) {
                const $a = $('#onb-alert');
                $a.text('Could not save phone numbers. ' + e.message)
                    .removeClass('d-none').removeClass('alert-success').addClass('alert-danger');
                console.error(e);
            }
        });

        // Open Services sheet
        $(document).on('click', '.js-onb-open-services', function(e){
            e.preventDefault();
            const $body  = $('#onboardingModalBody');
            const $sheet = $('#onb-sheet-services');
            if ($sheet.length) {
                $body.html($sheet.removeClass('d-none'));
                $('#onb-alert').addClass('d-none').text('');
            }
        });

        // Back from Services to small list
        $(document).on('click', '.js-onb-prev-services', function(){
            const $body  = $('#onboardingModalBody');
            $.ajax({
                url: '<?= $this->Url->build(["controller"=>"Onboarding","action"=>"modal"]) ?>',
                method: 'GET',
                headers: {'X-Requested-With':'XMLHttpRequest'}
            }).done(function(html){ $body.html(html); });
        });

        // Add/Remove rows
        $(document).on('click', '#onb-add-service', function(e){ e.preventDefault(); addService(); });
        $(document).on('click', '.onb-remove-service', function(e){
            e.preventDefault();
            $(this).closest('.onb-service').remove();
            reindexServices();
        });

        // Save services
        $(document).on('click', '.js-onb-save-services', async function(){
            try {
                reindexServices();
                const form = document.getElementById('onb-form-services');
                const data = new FormData(form);
                const res  = await fetch('<?= $this->Url->build("/onboarding/save-services") ?>', {
                    method: 'POST',
                    headers: { 'X-CSRF-Token': '<?= $this->request->getAttribute("csrfToken") ?>' },
                    body: data
                });
                const text = await res.text();
                let json; try { json = JSON.parse(text); } catch(_) {}
                if (!res.ok || !json || !json.ok) throw new Error((json && json.error) || ('HTTP ' + res.status));

                // reload small list after save
                $('#onboardingModalBody').load('<?= $this->Url->build(["controller"=>"Onboarding","action"=>"modal"]) ?>');
            } catch (e) {
                const $a = $('#onb-alert');
                $a.text('Could not save services. ' + e.message)
                    .removeClass('d-none').removeClass('alert-success').addClass('alert-danger');
                console.error(e);
            }
        });

    });

    document.addEventListener('DOMContentLoaded', function () {
        var currentLi = document.querySelector('li#current-page');
        var currentA  = document.querySelector('a#current-page');

        if (currentLi) {
            currentLi.classList.add('is-active');
            var link = currentLi.querySelector('a.nav-link');
            if (link) link.setAttribute('aria-current', 'page');

            var parentDropdown = currentLi.closest('li.dropdown');
            if (parentDropdown) {
                parentDropdown.classList.add('is-open', 'is-active');
                var trigger = parentDropdown.querySelector('> a.nav-link');
                if (trigger) trigger.setAttribute('aria-expanded', 'true');
            }
        }

        if (currentA) {
            currentA.setAttribute('aria-current', 'page');
            var li = currentA.closest('li');
            if (li) li.classList.add('is-active');

            var parentDropdown2 = currentA.closest('li.dropdown');
            if (parentDropdown2) {
                parentDropdown2.classList.add('is-open', 'is-active');
                var trigger2 = parentDropdown2.querySelector('> a.nav-link');
                if (trigger2) trigger2.setAttribute('aria-expanded', 'true');
            }
        }
    });
</script>

<script>
    /* Keep this one if you use the small “Mark as done” buttons in the list */
    (function () {
        const COMPLETE_URL_BASE = "<?= $this->Url->build('/onboarding/complete/') ?>";

        async function markStepDone(step, btn) {
            btn.disabled = true;
            try {
                const url = COMPLETE_URL_BASE + encodeURIComponent(step);
                const res  = await fetch(url, { method: 'GET', headers: { 'Accept': 'application/json' } });
                const text = await res.text();
                if (!res.ok) throw new Error('HTTP ' + res.status + ' ' + text);

                const data = JSON.parse(text);
                if (!data.ok) throw new Error(data.error || 'Failed');

                const bar = document.getElementById('ob-progress-bar');
                const pct = document.getElementById('ob-progress-label');
                if (bar) bar.style.width = data.percent + '%';
                if (pct) pct.textContent = data.percent + '%';

                const navBar = document.querySelector('.navbar .progress-bar');
                const navPct = document.querySelector('.navbar .progress + span, .navbar .ml-2');
                if (navBar) navBar.style.width = data.percent + '%';
                if (navPct) navPct.textContent = data.percent + '%';

                btn.textContent = 'Done';
                btn.classList.remove('btn-success');
                btn.classList.add('btn-secondary');
            } catch (e) {
                alert('Could not mark as done. ' + e.message);
                btn.disabled = false;
            }
        }

        document.addEventListener('click', function (e) {
            const btn = e.target.closest('.js-mark-step');
            if (!btn) return;
            e.preventDefault();
            const step = parseInt(btn.getAttribute('data-step') || '0', 10);
            if (step > 0) markStepDone(step, btn);
        });
    })();
</script>
<script src="https://cdn.jsdelivr.net/npm/intro.js/minified/intro.min.js"></script>

<?php
$user = $this->request->getAttribute('identity');
?>

<script>
    document.addEventListener("DOMContentLoaded", function () {

        function startTour() {
            const tour = introJs().setOptions({
                nextLabel: 'Next →',
                prevLabel: '← Back',
                doneLabel: 'Finish',
                tooltipPosition: 'right',
                showProgress: true
            });

            const openAfterTour = function () {
                if (typeof window.openOnboardingModal === 'function') {
                    setTimeout(function(){ window.openOnboardingModal(); }, 150);
                } else {
                    const link = document.getElementById('onboarding-link');
                    if (link) setTimeout(function(){ link.click(); }, 150);
                }
            };

            tour.oncomplete(openAfterTour)
                .onexit(openAfterTour)
                .start();
        }

        <?php if ($this->request->getSession()->read('FirstTimeLogin')) : ?>
        startTour();
        <?php $this->request->getSession()->delete('FirstTimeLogin'); ?>
        <?php endif; ?>

        const tourButton = document.getElementById("show-tour");
        if (tourButton) tourButton.addEventListener("click", startTour);
    });
</script>

<?= $this->fetch('scriptBottom') ?>
</body>
</html>
