<?php
/** @var \App\Model\Entity\ClinicService[] $services */
$csrf = $this->request->getAttribute('csrfToken');
?>
<div class="modal-header">
    <h5 class="modal-title">Services</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>×</span></button>
</div>

<div class="modal-body">
    <div id="onb-sv-alert" class="alert alert-danger d-none"></div>

    <form id="onb-form-services" autocomplete="off">
        <input type="hidden" name="_csrfToken" value="<?= h($csrf) ?>">

        <div id="onb-services">
            <?php foreach (($services ?? []) as $i => $s): ?>
                <div class="card shadow-sm mb-3 p-3 onb-service">
                    <div class="d-flex align-items-center mb-2">
                        <strong class="mr-2">Service</strong>
                        <a href="#" class="ml-auto text-danger onb-remove-service">Remove</a>
                    </div>

                    <input type="hidden" name="services[<?= $i ?>][id]" value="<?= (int)$s->id ?>">

                    <div class="form-row">
                        <div class="form-group col-md-5">
                            <label>Name *</label>
                            <input class="form-control" name="services[<?= $i ?>][name]" value="<?= h($s->name) ?>">
                        </div>
                        <div class="form-group col-md-2">
                            <label>Code</label>
                            <input class="form-control" name="services[<?= $i ?>][code]" value="<?= h($s->code) ?>">
                        </div>
                        <div class="form-group col-md-2">
                            <label>Duration (min)</label>
                            <input class="form-control" name="services[<?= $i ?>][duration_minutes]" value="<?= (int)$s->duration_minutes ?>">
                        </div>
                        <div class="form-group col-md-2">
                            <label>Price (AU$)</label>
                            <input class="form-control" name="services[<?= $i ?>][price]" value="<?= $s->price_cents !== null ? number_format($s->price_cents/100,2) : '' ?>">
                        </div>
                        <div class="form-group col-md-1">
                            <label>Active</label>
                            <select class="form-control" name="services[<?= $i ?>][active]">
                                <option value="1" <?= (int)$s->active === 1 ? 'selected' : '' ?>>Yes</option>
                                <option value="0" <?= (int)$s->active !== 1 ? 'selected' : '' ?>>No</option>
                            </select>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <button id="onb-add-service" class="btn btn-sm btn-outline-primary">+ Add another service</button>
    </form>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-success" id="onb-save-services">Save</button>
</div>

<script type="text/template" id="tpl-onb-service">
    <div class="card shadow-sm mb-3 p-3 onb-service">
        <div class="d-flex align-items-center mb-2">
            <strong class="mr-2">Service</strong>
            <a href="#" class="ml-auto text-danger onb-remove-service">Remove</a>
        </div>
        <input type="hidden" name="services[__IDX__][id]" value="">
        <div class="form-row">
            <div class="form-group col-md-5">
                <label>Name *</label>
                <input class="form-control" name="services[__IDX__][name]" value="">
            </div>
            <div class="form-group col-md-2">
                <label>Code</label>
                <input class="form-control" name="services[__IDX__][code]" value="">
            </div>
            <div class="form-group col-md-2">
                <label>Duration (min)</label>
                <input class="form-control" name="services[__IDX__][duration_minutes]" value="">
            </div>
            <div class="form-group col-md-2">
                <label>Price (AU$)</label>
                <input class="form-control" name="services[__IDX__][price]" value="">
            </div>
            <div class="form-group col-md-1">
                <label>Active</label>
                <select class="form-control" name="services[__IDX__][active]">
                    <option value="1" selected>Yes</option>
                    <option value="0">No</option>
                </select>
            </div>
        </div>
    </div>
</script>

<script>
(function(){
    const $wrap  = $('#onb-services');
    const $alert = $('#onb-sv-alert');

    function nextIdx() {
        let max = -1;
        $wrap.find('[name^="services["][name$="[name]"]').each(function(){
            const m = this.name.match(/^services\[(\d+)]\[name]/);
            if (m) max = Math.max(max, parseInt(m[1],10));
        });
        return max + 1;
    }

    $(document).on('click','#onb-add-service',function(e){
        e.preventDefault();
        const tpl = $('#tpl-onb-service').html();
        const html = tpl.replace(/__IDX__/g, String(nextIdx()));
        $wrap.append(html);
    });

    $(document).on('click','.onb-remove-service',function(e){
        e.preventDefault();
        $(this).closest('.onb-service').remove();
    });

    $(document).on('click','#onb-save-services', async function(){
        try {
            $alert.addClass('d-none').text('');
            const form = document.getElementById('onb-form-services');
            const data = new FormData(form);
            const res  = await fetch('<?= $this->Url->build("/onboarding/save-services") ?>', {
                method: 'POST',
                headers: { 'X-CSRF-Token': '<?= $csrf ?>' },
                body: data
            });
            const text = await res.text();
            let json = null; try { json = JSON.parse(text); } catch(e){}
            if (!res.ok || !json || !json.ok) {
                throw new Error((json && (json.errors || json.error)) ? [].concat(json.errors || [json.error]).join('; ') : 'Save failed');
            }
            $('.modal:visible').modal('hide');
        } catch (e) {
            $alert.removeClass('d-none').text(e.message);
        }
    });
})();
</script>
