<?php
$done    = (int)$state->step1_done + (int)$state->step2_done;
$percent = (int)round($done * 50);
$csrf = $this->request->getAttribute('csrfToken');

/** @var \App\Model\Entity\Clinic|null $clinic */
$clinic = $clinic ?? null;

// safe getter for clinic fields]
$C = function(string $k) use ($clinic) {
    return h($clinic->$k ?? '');
};


?>
<div class="mb-3 d-flex align-items-center">
    <div class="flex-grow-1">
        <div class="progress" style="height:8px;"><div id="ob-progress-bar" class="progress-bar" style="width:<?= $percent ?>%"></div></div>
    </div>
    <strong id="ob-progress-label" class="ml-2"><?= $percent ?>%</strong>
</div>

<!-- inline flash / error banner -->
<div id="onb-alert" class="alert alert-danger d-none" role="alert"></div>

<!-- Small list -->
<ul class="list-group mb-3">
    <li class="list-group-item d-flex justify-content-between align-items-center">
        <div>Business Information</div>
        <div>
            <a href="#" class="btn btn-sm btn-outline-primary js-onb-open" data-url="<?= $this->Url->build('/onboarding/bizinfo') ?>">Open</a>
            <button
                class="btn btn-sm btn-success ml-2 js-mark-step"
                data-url="<?= $this->Url->build(['controller'=>'Onboarding','action'=>'completeStep',1], ['fullBase'=>false]) ?>"
            >Mark as done</button>
        </div>
    </li>
    <li class="list-group-item d-flex justify-content-between align-items-center">
        <div>Services</div>
        <div>
            <a href="#" class="btn btn-sm btn-outline-primary js-onb-open-services">Open</a>
            <button class="btn btn-sm btn-success ml-2 js-mark-step" data-step="2">Mark as done</button>
        </div>
    </li>
    <!-- add other checklist items here if you want -->
</ul>

<div class="d-flex justify-content-between">
    <?= $this->Html->link('Dismiss', ['controller' => 'Onboarding', 'action' => 'dismiss'], ['class' => 'btn btn-outline-secondary']) ?>
</div>

<!-- Hidden “sheet” (wider content) loaded into the SAME modal body -->
<div id="onb-sheet-bizinfo" class="d-none">
    <h6 class="mb-3">Add your practice details</h6>
    <div id="onb-practice-section">
        <form id="onb-form-practice" autocomplete="off">
            <input type="hidden" name="_csrfToken" value="<?= h($this->request->getAttribute('csrfToken')) ?>">

            <!-- 🔹 NEW: Business Name -->
            <div class="form-group mb-3">
                <div class="onb-biz-label">Business Name</div>
                <input id="ob-biz-name" name="clinic_name" type="text" class="form-control"
                       placeholder="Enter your business name"
                       value="<?= $C('name' ?? '') ?>">
            </div>

            <!-- PRIMARY location (names MUST stay flat exactly as below) -->
            <div class="onb-location onb-location--primary card shadow-sm mb-3 p-3">
                <div class="d-flex align-items-center mb-2">
                    <strong class="mr-2">Location</strong>
                    <span class="badge badge-secondary">Primary</span>
                </div>

                <div class="form-group">
                    <label>Street Address</label>
                    <input id="ob-street" name="address_street" type="text" class="form-control"
                           value="<?= h($primaryLoc->street ?? '') ?>">
                </div>

                <div class="form-row">
                    <div class="form-group col-md-3">
                        <label>Suburb</label>
                        <input id="ob-suburb" name="address_suburb" type="text" class="form-control"
                               value="<?= h($primaryLoc->suburb ?? '') ?>">
                    </div>
                    <div class="form-group col-md-3">
                        <label>State</label>
                        <input id="ob-state" name="address_state" type="text" class="form-control"
                               value="<?= h($primaryLoc->state ?? '') ?>">
                    </div>
                    <div class="form-group col-md-3">
                        <label>Postcode</label>
                        <input id="ob-postcode" name="address_postcode" type="text" class="form-control"
                               value="<?= h($primaryLoc->postcode ?? '') ?>">
                    </div>
                    <div class="form-group col-md-3">
                        <label>Country</label>
                        <input id="ob-country" name="address_country" type="text" class="form-control"
                               value="<?= h($primaryLoc->country ?? '') ?>">
                    </div>
                </div>
            </div>

            <!-- Additional locations (array names so backend can consume later) -->
            <div id="onb-locations">
                <?php if (!empty($extraLocs)) : ?>
                    <?php foreach ($extraLocs as $i => $loc): ?>
                        <div class="onb-location card shadow-sm mb-3 p-3">
                            <div class="d-flex align-items-center mb-2">
                                <strong class="mr-2">Location</strong>
                                <span class="badge badge-light">Additional</span>
                                <a href="#" class="ml-auto text-danger onb-remove-location">Remove this location</a>
                            </div>
                            <div class="form-group">
                                <label>Street Address</label>
                                <input name="locations[<?= $i+1 ?>][address_street]" type="text" class="form-control"
                                       value="<?= h($loc->street ?? '') ?>">
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-3">
                                    <label>Suburb</label>
                                    <input name="locations[<?= $i+1 ?>][address_suburb]" type="text" class="form-control"
                                           value="<?= h($loc->suburb ?? '') ?>">
                                </div>
                                <div class="form-group col-md-3">
                                    <label>State</label>
                                    <input name="locations[<?= $i+1 ?>][address_state]" type="text" class="form-control"
                                           value="<?= h($loc->state ?? '') ?>">
                                </div>
                                <div class="form-group col-md-3">
                                    <label>Postcode</label>
                                    <input name="locations[<?= $i+1 ?>][address_postcode]" type="text" class="form-control"
                                           value="<?= h($loc->postcode ?? '') ?>">
                                </div>
                                <div class="form-group col-md-3">
                                    <label>Country</label>
                                    <input name="locations[<?= $i+1 ?>][address_country]" type="text" class="form-control"
                                           value="<?= h($loc->country ?? '') ?>">
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>

            <button id="onb-add-location" class="btn btn-sm btn-outline-primary">+ Add another location</button>

            <div class="d-flex justify-content-between mt-3">
                <button type="button" class="btn btn-light js-onb-back">Back</button>
                <button type="button" class="btn btn-primary js-onb-next">Next</button>
            </div>
        </form>
    </div>

    <script type="text/template" id="tpl-onb-location">
        <div class="onb-location card shadow-sm mb-3 p-3">
            <div class="d-flex align-items-center mb-2">
                <strong class="mr-2">Location</strong>
                <span class="badge badge-light">Additional</span>
                <a href="#" class="ml-auto text-danger onb-remove-location">Remove this location</a>
            </div>
            <div class="form-group">
                <label>Street Address</label>
                <input name="locations[__IDX__][address_street]" type="text" class="form-control">
            </div>
            <div class="form-row">
                <div class="form-group col-md-3">
                    <label>Suburb</label>
                    <input name="locations[__IDX__][address_suburb]" type="text" class="form-control">
                </div>
                <div class="form-group col-md-3">
                    <label>State</label>
                    <input name="locations[__IDX__][address_state]" type="text" class="form-control">
                </div>
                <div class="form-group col-md-3">
                    <label>Postcode</label>
                    <input name="locations[__IDX__][address_postcode]" type="text" class="form-control">
                </div>
                <div class="form-group col-md-3">
                    <label>Country</label>
                    <input name="locations[__IDX__][address_country]" type="text" class="form-control">
                </div>
            </div>
        </div>
    </script>

    <div id="onb-phone-section" class="d-none">
        <form id="onb-form-phone" autocomplete="off">
            <input type="hidden" name="_csrfToken" value="<?= h($this->request->getAttribute('csrfToken')) ?>">

            <div id="onb-phones">
                <div class="onb-phone onb-phone--primary card shadow-sm mb-3 p-3">
                    <div class="d-flex align-items-center mb-2">
                        <strong class="mr-2">Phone</strong>
                        <span class="badge badge-secondary">Primary</span>
                    </div>
                    <input name="phones[0]" type="text" class="form-control" value="<?= h($primaryPhone ?? '') ?>">
                </div>

                <?php if (!empty($extraPhones)) : ?>
                    <?php foreach ($extraPhones as $i => $p): ?>
                        <div class="onb-phone card shadow-sm mb-3 p-3">
                            <div class="d-flex align-items-center mb-2">
                                <strong class="mr-2">Phone</strong>
                                <a href="#" class="ml-auto text-danger onb-remove-phone">Remove</a>
                            </div>
                            <input name="phones[<?= $i+1 ?>]" type="text" class="form-control" value="<?= h($p) ?>">
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>

            <button id="onb-add-phone" class="btn btn-sm btn-outline-primary">+ Add another phone number</button>

            <div class="d-flex justify-content-between mt-3">
                <button type="button" class="btn btn-light js-onb-prev">Back</button>
                <button type="button" class="btn btn-success js-onb-finish">Finish</button>
            </div>
        </form>
    </div>

    <!-- template for extra phones -->
    <script type="text/template" id="tpl-onb-phone">
        <div class="onb-phone card shadow-sm mb-3 p-3">
            <div class="d-flex align-items-center mb-2">
                <strong class="mr-2">Phone</strong>
                <a href="#" class="ml-auto text-danger onb-remove-phone">Remove</a>
            </div>
            <input name="phones[__IDX__]" type="text" class="form-control">
        </div>
    </script>
</div>

<!-- Hidden “sheet”: Services (separate from Business Info) -->
<div id="onb-sheet-services" class="d-none">
    <h6 class="mb-3">Add your services</h6>

    <form id="onb-form-services" autocomplete="off">
        <input type="hidden" name="_csrfToken" value="<?= h($this->request->getAttribute('csrfToken')) ?>">

        <div id="onb-services">
            <?php if (!empty($services ?? [])) : ?>
                <?php foreach (($services ?? []) as $i => $srv): ?>
                    <div class="onb-service card shadow-sm mb-3 p-3">
                        <div class="d-flex align-items-center mb-2">
                            <strong class="mr-2">Service</strong>
                            <a href="#" class="ml-auto text-danger onb-remove-service">Remove</a>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label>Name</label>
                                <input name="services[<?= $i ?>][name]" type="text" class="form-control"
                                       value="<?= h($srv->name ?? '') ?>">
                            </div>
                            <div class="form-group col-md-2">
                                <label>Code</label>
                                <input name="services[<?= $i ?>][code]" type="text" class="form-control"
                                       value="<?= h($srv->code ?? '') ?>">
                            </div>
                            <div class="form-group col-md-3">
                                <label>Duration (minutes)</label>
                                <input name="services[<?= $i ?>][duration_minutes]" type="number" min="1" class="form-control"
                                       value="<?= h($srv->duration_minutes ?? '') ?>">
                            </div>
                            <div class="form-group col-md-3">
                                <label>Price (AU$)</label>
                                <input name="services[<?= $i ?>][price_cents]" type="number" min="0" class="form-control"
                                       value="<?= isset($srv->price_cents) ? h((int)$srv->price_cents) : '' ?>">
                                <small class="text-muted">Store as cents (e.g., 100 = $1.00)</small>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <!-- one empty row if no services yet -->
                <div class="onb-service card shadow-sm mb-3 p-3">
                    <div class="d-flex align-items-center mb-2">
                        <strong class="mr-2">Service</strong>
                        <a href="#" class="ml-auto text-danger onb-remove-service">Remove</a>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label>Name</label>
                            <input name="services[0][name]" type="text" class="form-control">
                        </div>
                        <div class="form-group col-md-2">
                            <label>Code</label>
                            <input name="services[0][code]" type="text" class="form-control">
                        </div>
                        <div class="form-group col-md-3">
                            <label>Duration (minutes)</label>
                            <input name="services[0][duration_minutes]" type="number" min="1" class="form-control">
                        </div>
                        <div class="form-group col-md-3">
                            <label>Price (AU$)</label>
                            <input name="services[0][price_cents]" type="number" min="0" class="form-control">
                            <small class="text-muted">Store as cents (e.g., 100 = $1.00)</small>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <button id="onb-add-service" class="btn btn-sm btn-outline-primary">+ Add another service</button>

        <div class="d-flex justify-content-between mt-3">
            <button type="button" class="btn btn-light js-onb-prev-services">Back</button>
            <button type="button" class="btn btn-success js-onb-save-services">Save</button>
        </div>
    </form>

    <!-- template for extra services -->
    <script type="text/template" id="tpl-onb-service">
        <div class="onb-service card shadow-sm mb-3 p-3">
            <div class="d-flex align-items-center mb-2">
                <strong class="mr-2">Service</strong>
                <a href="#" class="ml-auto text-danger onb-remove-service">Remove</a>
            </div>
            <div class="form-row">
                <div class="form-group col-md-4">
                    <label>Name</label>
                    <input name="services[__IDX__][name]" type="text" class="form-control">
                </div>
                <div class="form-group col-md-2">
                    <label>Code</label>
                    <input name="services[__IDX__][code]" type="text" class="form-control">
                </div>
                <div class="form-group col-md-3">
                    <label>Duration (minutes)</label>
                    <input name="services[__IDX__][duration_minutes]" type="number" min="1" class="form-control">
                </div>
                <div class="form-group col-md-3">
                    <label>Price (AU$)</label>
                    <input name="services[__IDX__][price_cents]" type="number" min="0" class="form-control">
                    <small class="text-muted">Store as cents (e.g., 100 = $1.00)</small>
                </div>
            </div>
        </div>
    </script>
</div>
