<?php
$street   = (string)($clinic->address_street   ?? '');
$suburb   = (string)($clinic->address_suburb   ?? '');
$state    = (string)($clinic->address_state    ?? '');
$postcode = (string)($clinic->address_postcode ?? '');
$country  = (string)($clinic->address_country  ?? 'Australia');
$phone    = (string)($clinic->business_phone   ?? '');
$name    = (string)($clinic->name   ?? '');
?>
<style>
    #onboardingModal .modal-dialog{width:96%;max-width:1200px}
    .onb-steps{display:flex;gap:8px;margin:8px 0 16px}
    .onb-step{height:6px;flex:1;background:#e9ecef;border-radius:999px;overflow:hidden}
    .onb-step.is-active .bar,.onb-step.is-done .bar{background:#6777ef}
    .onb-step .bar{display:block;width:100%;height:100%;background:transparent}
</style>

<div class="container-fluid">
    <div class="onb-steps">
        <div class="onb-step is-active" data-step="1"><span class="bar"></span></div>
        <div class="onb-step" data-step="2"><span class="bar"></span></div>
    </div>

    <section id="step1">
        <h5 class="mb-3">Add your practice details</h5>
        <form id="form-practice">
            <div class="form-row">
                <div class="form-group col-12">
                    <label for="bizName">Business Name</label>
                    <input
                        type="text"
                        class="form-control"
                        id="bizName"
                        name="clinic_name"
                        placeholder="Enter your business name"
                        value="<?= h($name) ?>">
                </div>
                <div class="form-group col-12">
                    <label>Street Address</label>
                    <input name="street" class="form-control" value="<?= h($street) ?>">
                </div>
                <div class="form-group col-md-5">
                    <label>Suburb</label>
                    <input name="suburb" class="form-control" value="<?= h($suburb) ?>">
                </div>
                <div class="form-group col-md-3">
                    <label>State</label>
                    <input name="state" class="form-control" value="<?= h($state) ?>">
                </div>
                <div class="form-group col-md-2">
                    <label>Postcode</label>
                    <input name="postcode" class="form-control" value="<?= h($postcode) ?>">
                </div>
                <div class="form-group col-md-2">
                    <label>Country</label>
                    <input name="country" class="form-control" value="<?= h($country) ?>">
                </div>
            </div>
            <div class="d-flex justify-content-between">
                <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">Back</button>
                <button type="submit" class="btn btn-primary">Next</button>
            </div>
        </form>
    </section>

    <section id="step2" class="d-none">
        <h5 class="mb-3">Business Phone Number</h5>
        <form id="form-phone">
            <div class="form-group">
                <label>Phone Number</label>
                <input name="phone" class="form-control" placeholder="e.g. 0412 345 678" value="<?= h($phone) ?>">
            </div>
            <div class="d-flex justify-content-between">
                <button type="button" class="btn btn-outline-secondary js-prev">Back</button>
                <div>
                    <button type="button" class="btn btn-link mr-2 js-skip">Skip for now</button>
                    <button type="submit" class="btn btn-primary">Finish</button>
                </div>
            </div>
        </form>
    </section>
</div>

<script>
    (function(){
        const step1 = document.getElementById('step1');
        const step2 = document.getElementById('step2');

        function setStep(n) {
            step1.classList.toggle('d-none', n !== 1);
            step2.classList.toggle('d-none', n !== 2);
            document.querySelectorAll('.onb-step').forEach(el => {
                const k = +el.dataset.step;
                el.classList.toggle('is-active', k === n);
                el.classList.toggle('is-done', k < n);
            });
        }

        // 🔹 Save Business Info (Business Name + Location)
        document.getElementById('form-practice').addEventListener('submit', async function(e) {
            e.preventDefault();
            const res = await fetch('<?= $this->Url->build("/onboarding/save-practice") ?>', {
                method: 'POST',
                body: new FormData(this)
            });
            if (!res.ok) return alert('Could not save practice details.');
            setStep(2);
        });

        // Back button
        document.querySelector('#step2 .js-prev').addEventListener('click', () => setStep(1));

        // Skip button
        document.querySelector('#step2 .js-skip').addEventListener('click', () => $('#onboardingModal').modal('hide'));

        // 🔹 Save Phone
        document.getElementById('form-phone').addEventListener('submit', async function(e) {
            e.preventDefault();
            const res = await fetch('<?= $this->Url->build("/onboarding/save-phone") ?>', {
                method: 'POST',
                body: new FormData(this)
            });
            if (!res.ok) return alert('Could not save phone.');

            // mark step complete
            try {
                await fetch('<?= $this->Url->build("/onboarding/complete-step/1") ?>', {
                    headers: {'Accept':'application/json'}
                });
            } catch (e) {}

            $('#onboardingModal').modal('hide');
        });

        setStep(1);
    })();
</script>
