<?php
/** @var \App\View\AppView $this */
/** @var string $token */
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
  <title>Aegis - Admin Dashboard Template</title>
  <!-- General CSS Files -->
  <link rel="stylesheet" href="webroot/css/app.min.css">
  <!-- Template CSS -->
  <link rel="stylesheet" href="webroot/css/style.css">
  <link rel="stylesheet" href="webroot/css/components.css">
  <!-- Custom style CSS -->
  <link rel="stylesheet" href="webroot/css/custom.css">
  <link rel='shortcut icon' type='image/x-icon' href='webroot/img/favicon.ico' />
</head>

<body>
  <div class="loader"></div>
  <div id="app">
    <section class="section">
      <div class="container mt-5">
        <div class="row">
          <div class="col-12 col-sm-8 offset-sm-2 col-md-6 offset-md-3 col-lg-6 offset-lg-3 col-xl-4 offset-xl-4">
              <div class="card card-primary">
                  <div class="card-header"><h4>Reset Password</h4></div>
                  <div class="card-body">
                      <?= $this->Flash->render() ?>

                      <?= $this->Form->create(null, [
                          'url' => ['controller'=>'Login','action'=>'reset', $token],
                          'autocomplete' => 'off',
                      ]) ?>

                      <?= $this->Form->control('password', [
                          'label' => 'New Password',
                          'type' => 'password',
                          'required' => true,
                          'class' => 'form-control',
                      ]) ?>

                      <button type="button"
                              class="password-toggle"
                              data-target="#password"
                              aria-label="Show password">
                          <i class="far fa-eye"></i>
                      </button>

                      <?= $this->Form->control('password_confirm', [
                          'label' => 'Confirm Password',
                          'type' => 'password',
                          'required' => true,
                          'class' => 'form-control',
                      ]) ?>

                      <?= $this->Form->button('Update Password', ['class' => 'btn btn-primary btn-block mt-3']) ?>
                      <?= $this->Form->end() ?>

                  </div>
              </div>
          </div>
        </div>
      </div>
    </section>
  </div>
  <!-- General JS Scripts -->
  <script src="webroot/js/app.min.js"></script>
  <!-- JS Libraies -->
  <!-- Page Specific JS File -->
  <!-- Template JS File -->
  <script src="webroot/js/scripts.js"></script>
  <!-- Custom JS File -->
  <script src="webroot/js/custom.js"></script>
  <script>
      (function () {
          document.addEventListener('click', function (e) {
              const btn = e.target.closest('.password-toggle');
              if (!btn) return;

              const input = document.querySelector(btn.dataset.target);
              if (!input) return;

              const shown = input.type === 'text';
              input.type = shown ? 'password' : 'text';
              btn.setAttribute('aria-label', shown ? 'Show password' : 'Hide password');

              const icon = btn.querySelector('i');
              if (icon) {
                  icon.classList.toggle('fa-eye');
                  icon.classList.toggle('fa-eye-slash');
              }
          });
      })();
  </script>
</body>

</html>
