<?php
/**
 * @var \App\View\AppView $this
 * @var string $message
 * @var string $url
 * @var \Throwable|null $error
 */
use Cake\Core\Configure;
use Cake\Error\Debugger;

$this->layout = 'error';

if (Configure::read('debug')) :
    $this->layout = 'dev_error';

    $this->assign('title', $message);
    $this->assign('templateName', 'error401.php');

    $this->start('file');
    ?>
    <?php if (isset($error) && $error instanceof \Throwable) : ?>
    <?php $file = $error->getFile(); $line = $error->getLine(); ?>
    <strong>Error in: </strong>
    <?= $this->Html->link(sprintf('%s, line %s', Debugger::trimPath($file), $line), Debugger::editorUrl($file, $line)); ?>
<?php endif; ?>
    <?php
    echo $this->element('auto_table_warning');
    $this->end();
endif;
?>
<h2><?= h(__('Unauthorized')) ?></h2>
<p class="error">
    <strong><?= h(__('Error')) ?>: </strong>
    <?= h($message) ?>
</p>
