<?php
$this->assign('title', 'Change Password');
?>

<section class="section">
    <div class="section-body">
        <div class="row">
            <div class="col-12 col-md-8 col-lg-6">
                <div class="card">
                    <div class="card-body">Please ensure you have changed your password at least once.</div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">Change Password</h4>
                    </div>
                    <div class="card-body">
                        <?= $this->Flash->render() ?>

                        <?= $this->Form->create(null, ['novalidate' => true, 'class' => 'needs-validation']) ?>

                        <div class="form-group">
                            <?= $this->Form->label('old_password', 'Current Password') ?>
                            <?= $this->Form->password('old_password', [
                                'class' => 'form-control',
                                'required' => true,
                                'autocomplete' => 'current-password'
                            ]) ?>
                        </div>

                        <div class="form-group">
                            <?= $this->Form->label('new_password', 'New Password') ?>
                            <?= $this->Form->password('new_password', [
                                'class' => 'form-control',
                                'required' => true,
                                'autocomplete' => 'new-password',
                                'placeholder' => 'At least 8 chars, incl. 1 uppercase & 1 number'
                            ]) ?>
                        </div>

                        <div class="form-group">
                            <?= $this->Form->label('new_password_confirm', 'Confirm New Password') ?>
                            <?= $this->Form->password('new_password_confirm', [
                                'class' => 'form-control',
                                'required' => true,
                                'autocomplete' => 'new-password'
                            ]) ?>
                        </div>

                        <div class="form-group mb-0">
                            <?= $this->Form->button('Update Password', ['class' => 'btn btn-primary']) ?>
                            <a href="<?= $this->Url->build(['action' => 'profile']) ?>"
                               class="btn btn-secondary">Cancel</a>
                        </div>

                        <?= $this->Form->end() ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
