<?php
namespace App\Service;

use Cake\I18n\FrozenTime;
use Cake\Datasource\Paging\Paginator;
use Cake\ORM\TableRegistry;
use Cake\ORM\Locator\LocatorInterface;
class ParticipantAlertsService
{
    private LocatorInterface $locator;

    public function __construct(?LocatorInterface $locator = null)
    {
        $this->locator = $locator ?? TableRegistry::getTableLocator();
    }

    public function activeAlerts(int $participantId): array
    {
        $Alerts = $this->locator->get('ParticipantAlerts');
        $now = FrozenTime::now();

        return $Alerts->find()
            ->where(['participant_id' => $participantId])
            ->andWhere([
                'OR' => [
                    'starts_at IS' => null,
                    'starts_at <=' => $now,
                ],
            ])
            ->andWhere([
                'OR' => [
                    'ends_at IS' => null,
                    'ends_at >=' => $now,
                ],
            ])
            ->orderDesc('id')
            ->all()
            ->toList();
    }

}
