<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

class ParticipantAddressesTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('participant_addresses');
        $this->setPrimaryKey('id');

        $this->belongsTo('Participants', [
            'foreignKey' => 'participant_id',
            'joinType'   => 'INNER',
        ]);
    }

    public function validationDefault(Validator $v): Validator
    {
        $v->integer('participant_id')->allowEmptyString('participant_id');

        $v->allowEmptyString('address_line1');
        $v->allowEmptyString('address_line2');
        $v->allowEmptyString('city');
        $v->allowEmptyString('region');
        $v->allowEmptyString('postcode');
        $v->allowEmptyString('country');

        $v->inList('address_type', ['home','work','other'], 'Invalid address type')
            ->allowEmptyString('address_type');

        return $v;
    }

    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['participant_id'], 'Participants'));
        $rules->add(
            $rules->isUnique(
                ['participant_id','address_type'],
                'Each address type can only be used once.'
            ),
            ['errorField' => 'address_type']
        );
        return $rules;
    }

}

