<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * ClinicUser Entity
 *
 * @property int $id
 * @property int $clinic_id
 * @property int $login_id
 * @property string $role
 * @property \Cake\I18n\DateTime|null $created
 * @property \Cake\I18n\DateTime|null $modified
 *
 * @property \App\Model\Entity\Clinic $clinic
 * @property \App\Model\Entity\Login $login
 */
class ClinicUser extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'clinic_id' => true,
        'login_id' => true,
        'role' => true,
        'created' => true,
        'modified' => true,
        'clinic' => true,
        'login' => true,
    ];
}
