<?php
/**
 * Routes configuration.
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different URLs to chosen controllers and their actions (functions).
 *
 * It's loaded within the context of `Application::routes()` method which
 * receives a `RouteBuilder` instance `$routes` as method argument.
 *
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 */
use Cake\Routing\Route\DashedRoute;
use Cake\Routing\RouteBuilder;

/*
 * This file is loaded in the context of the `Application` class.
 * So you can use `$this` to reference the application class instance
 * if required.
 */
return function (RouteBuilder $routes): void {
    /*
     * The default class to use for all routes
     *
     * The following route classes are supplied with CakePHP and are appropriate
     * to set as the default:
     *
     * - Route
     * - InflectedRoute
     * - DashedRoute
     *
     * If no call is made to `Router::defaultRouteClass()`, the class used is
     * `Route` (`Cake\Routing\Route\Route`)
     *
     * Note that `Route` does not do any inflections on URLs which will result in
     * inconsistently cased URLs when used with `{plugin}`, `{controller}` and
     * `{action}` markers.
     */
    $routes->setRouteClass(DashedRoute::class);
    $routes->setExtensions(['json']);
    $routes->scope('/', function (RouteBuilder $builder): void {
        $builder->connect('/participants/search', ['controller' => 'Participants', 'action' => 'search']);

        $builder->connect('/',           ['controller' => 'Login',    'action' => 'index']);
        $builder->connect('/logout',     ['controller' => 'Login',    'action' => 'logout']);

        $builder->connect('/home',       ['controller' => 'Home',    'action' => 'index']);

        $builder->connect('/forgot',     ['controller' => 'Login',    'action' => 'forgot']);
        $builder->connect('/reset/*',     ['controller' => 'Login',    'action' => 'reset']);


        $builder->connect('/clinician',   ['controller' => 'ClinicianRegister', 'action' => 'index']);
        $builder->connect('/clinicians', ['controller' => 'Clinician', 'action' => 'index']);

        $builder->connect('/login/new', ['controller' => 'Login', 'action' => 'new']);

        $builder->connect('/dashboard',       ['controller' => 'Pages',    'action' => 'display', 'index']);
        $builder->connect('/pages/*',    'Pages::display');

        $builder->connect('/calendar',   ['controller' => 'Calendar', 'action' => 'index']);

        $builder->connect('/waitlist',   ['controller' => 'Waitlist', 'action' => 'index']);

        $builder->get( '/calendar/events',      ['controller' => 'Calendar', 'action' => 'events',     '_ext' => 'json']);
        $builder->get( '/calendar/clinicians',  ['controller' => 'Calendar', 'action' => 'clinicians', '_ext' => 'json']);
        $builder->get('/calendar/locations', ['controller' => 'Calendar', 'action' => 'locations']);
        $builder->post('/calendar/store',       ['controller' => 'Calendar', 'action' => 'store',      '_ext' => 'json']);

        $builder->post('/calendar/move/:id',    ['controller' => 'Calendar', 'action' => 'move',       '_ext' => 'json'])
            ->setPatterns(['id' => '\d+'])
            ->setPass(['id']);

        $builder->post('/calendar/status/:id',  ['controller' => 'Calendar', 'action' => 'status',     '_ext' => 'json'])
            ->setPatterns(['id' => '\d+'])
            ->setPass(['id']);

        $builder->post('/calendar/update/:id', ['controller'=>'Calendar','action'=>'update','_ext'=>'json'])
            ->setPatterns(['id'=>'\d+'])->setPass(['id']);

        $builder->post('/calendar/delete/:id', ['controller'=>'Calendar','action'=>'delete','_ext'=>'json'])
            ->setPatterns(['id'=>'\d+'])->setPass(['id']);

        $builder->connect('/clinician-profile', ['controller' => 'Clinician', 'action' => 'profile']);

        $builder->connect('/participants', ['controller' => 'Participants', 'action' => 'index']);
        $builder->connect('/participants/add', ['controller' => 'Participants', 'action' => 'add']);

        $builder->connect('/onboarding/modal', ['controller' => 'Onboarding', 'action' => 'modal']);

        $builder->connect('/onboarding/services', ['controller' => 'Onboarding', 'action' => 'services']);
        $builder->connect('/onboarding/save-services', ['controller' => 'Onboarding', 'action' => 'saveServices', '_method' => 'POST']);
        $builder->connect('/clinic-services/search', ['controller' => 'ClinicServices', 'action' => 'search']);

        $builder->connect('/onboarding/bizinfo', ['controller' => 'Onboarding', 'action' => 'bizInfo']);

        $builder->post('/onboarding/save-practice', ['controller'=>'Onboarding','action'=>'savePractice','_ext'=>'json']);
        $builder->post('/onboarding/save-phone',    ['controller'=>'Onboarding','action'=>'savePhone','_ext'=>'json']);

        $builder->connect('/onboarding/complete/:step', [
            'controller' => 'Onboarding', 'action' => 'completeStep'
        ])
            ->setPatterns(['step' => '\d+'])
            ->setPass(['step']);

        $builder->connect('/onboarding/dismiss', [
            'controller' => 'Onboarding', 'action' => 'dismiss'
        ]);
        $builder->connect('/onboarding/undismiss', ['controller' => 'Onboarding', 'action' => 'undismiss']);

        $builder->post('/reminders/schedule', ['controller' => 'Reminders', 'action' => 'schedule', '_ext' => 'json']);
        $builder->post('/reminders/cancel',   ['controller' => 'Reminders', 'action' => 'cancel',   '_ext' => 'json']);
        $builder->post('/reminders/resync',   ['controller' => 'Reminders', 'action' => 'resync',   '_ext' => 'json']);
        $builder->post('/reminders/dispatch', ['controller' => 'Reminders', 'action' => 'dispatch', '_ext' => 'json']);
        $builder->get('/reminders/dispatch',  ['controller' => 'Reminders', 'action' => 'dispatch', '_ext' => 'json']);
        $builder->post('/reminders/send-now', ['controller' => 'Reminders', 'action' => 'sendNow', '_ext' => 'json']);
        $builder->post('/clinician-profile/upload-avatar', ['controller' => 'Clinician', 'action' => 'uploadAvatar']);
        $builder->fallbacks(DashedRoute::class);
    });


    /*
     * If you need a different set of middleware or none at all,
     * open new scope and define routes there.
     *
     * ```
     * $routes->scope('/api', function (RouteBuilder $builder): void {
     *     // No $builder->applyMiddleware() here.
     *
     *     // Parse specified extensions from URLs
     *     // $builder->setExtensions(['json', 'xml']);
     *
     *     // Connect API actions here.
     * });
     * ```
     */
};
