<?php
/**
 * Layout: default
 */

$identity = $this->request->getAttribute('identity');
$isAdmin  = $identity && strtolower((string)($identity->get('role') ?? '')) === 'admin';
use Cake\ORM\TableRegistry;

$RoleFeatureSettings = TableRegistry::getTableLocator()->get('RoleFeatureSettings');
$featureMap = $RoleFeatureSettings->getVisibleMapForRole($isAdmin ? 'admin' : 'clinician');

$featureVisible = function(string $key) use ($featureMap): bool {
    return !empty($featureMap[$key]);
};

$fullName = 'User';
if ($identity) {
    $first = trim((string)($identity->get('first_name') ?? ''));
    $last  = trim((string)($identity->get('last_name') ?? ''));
    $fullName = trim($first . ' ' . $last) ?: (string)($identity->get('email') ?? 'User');
}

$canWaitlist  = true;
$canBilling   = $isAdmin || (bool)($identity->get('can_billing')   ?? false);
$canContacts  = $isAdmin || (bool)($identity->get('can_contacts')  ?? false);
$canMarketing = $isAdmin || (bool)($identity->get('can_marketing') ?? false);
$canProducts  = $isAdmin || (bool)($identity->get('can_products')  ?? false);
$canReports   = $isAdmin || (bool)($identity->get('can_reports')   ?? false);

$badgeParticipants = (int)($this->get('participantsBadge') ?? 0);

$currentController = $this->request->getParam('controller');
$currentAction     = $this->request->getParam('action');
$currentUrl = $this->request->getRequestTarget();

$onboardingState = null;
if ($isAdmin) {
    // read from session; if missing, try to warm it via helper
    $clinicId = $this->getRequest()->getSession()->read('Current.clinic_id');
    if ($clinicId === null && method_exists($this, 'currentClinicId')) {
        $clinicId = $this->currentClinicId();
    }

    if ($clinicId !== null) {
        $OnboardingStates = TableRegistry::getTableLocator()->get('OnboardingStates');
        $onboardingState  = $OnboardingStates->find()
            ->where(['clinic_id' => (int)$clinicId, 'dismissed' => 0])
            ->first();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Co-Linic AI - Admin Dashboard Template</title>
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css" />

    <?= $this->Html->meta('icon', $this->Url->build('/img/favicon.ico'), ['type' => 'image/x-icon']) ?>

    <?= $this->Html->css('/css/app.min.css') ?>
    <?= $this->Html->css('/bundles/jqvmap/dist/jqvmap.min.css') ?>
    <?= $this->Html->css('/bundles/weather-icon/css/weather-icons.min.css') ?>
    <?= $this->Html->css('/bundles/weather-icon/css/weather-icons-wind.min.css') ?>
    <?= $this->Html->css('/bundles/summernote/summernote-bs4.css') ?>
    <?= $this->Html->css('/css/style.css') ?>
    <?= $this->Html->css('/css/components.css') ?>
    <?= $this->Html->css('/css/custom.css') ?>
    <?= $this->Html->css('clinician_profile') ?>

    <?= $this->fetch('css') ?>
    <?= $this->fetch('meta') ?>
</head>

<body>
<div class="loader"></div>
<div id="app">
    <div class="main-wrapper main-wrapper-1">

        <div class="navbar-bg"></div>

        <nav class="navbar navbar-expand-lg main-navbar">
            <div class="form-inline mr-auto">
                <ul class="navbar-nav mr-3">
                    <li>
                        <a href="#" data-toggle="sidebar" class="nav-link nav-link-lg collapse-btn">
                            <i data-feather="align-justify"></i>
                        </a>
                    </li>
                    <li>
                        <a href="#" class="nav-link nav-link-lg fullscreen-btn">
                            <i data-feather="maximize"></i>
                        </a>
                    </li>
                    <li>
                        <form class="form-inline mr-auto" onsubmit="return false;">
                            <div class="search-element position-relative search-element-lg">
                                <input id="participant-search" class="form-control" type="text"
                                       placeholder="Search participants" autocomplete="off">
                                <button class="btn" type="submit">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                        </form>
                    </li>
                </ul>
            </div>
            <ul class="navbar-nav navbar-right">
                <?php if ($isAdmin && $onboardingState): ?>
                    <?php
                    $done    = (int)$onboardingState->step1_done + (int)$onboardingState->step2_done
                        + (int)$onboardingState->step3_done + (int)$onboardingState->step4_done;
                    $percent = (int)round($done * 25);
                    ?>
                    <li class="nav-item d-flex align-items-center mr-3">
                        <a href="#" id="onboarding-link" class="d-flex align-items-center" role="button" aria-haspopup="dialog" aria-controls="onboardingModal">
                            <div class="progress" style="width:150px; height:8px;">
                                <div class="progress-bar" role="progressbar"
                                     style="width: <?= $percent ?>%;"
                                     aria-valuenow="<?= $percent ?>" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="ml-2"><?= $percent ?>%</span>
                        </a>
                    </li>
                <?php endif; ?>
                <li class="dropdown">
                    <a href="#" data-toggle="dropdown" class="nav-link dropdown-toggle nav-link-lg nav-link-user">
                        <img alt="image" src="<?= $this->Url->image('TP/user.png') ?>" class="user-img-radious-style">
                        <span class="d-sm-none d-lg-inline-block"></span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right pullDown">
                        <div class="dropdown-title">Hello <?= h($fullName) ?></div>
                        <a href="<?= $this->Url->build('/clinician-profile') ?>" class="dropdown-item has-icon">
                            <i class="far fa-user"></i> Profile
                        </a>
                        <div class="dropdown-divider"></div>
                        <a href="<?= $this->Url->build('/logout') ?>" class="dropdown-item has-icon text-danger">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </div>
                </li>

            </ul>
        </nav>

        <div class="main-sidebar sidebar-style-2">
            <aside id="sidebar-wrapper">
                <div class="sidebar-brand">
                    <a href="<?= $this->Url->build('/dashboard') ?>">
                        <img alt="image" src="<?= $this->Url->image('TP/logo.png') ?>" class="header-logo" />
                        <span class="logo-name">Co-Linic AI</span>
                    </a>
                </div>
                <div class="sidebar-user">
                    <div class="sidebar-user-picture">
                        <a href="<?= $this->Url->build('/clinician-profile') ?>">
                            <img alt="image" src="<?= $this->Url->image('TP/userbig.png') ?>">
                        </a>
                    </div>
                    <div class="sidebar-user-details">
                        <div class="user-name"><?= h($fullName) ?></div>
                        <?php if ($isAdmin): ?>
                            <div class="user-role">Admin</div>
                        <?php else: ?>
                            <div class="user-role">Clinician</div>
                        <?php endif; ?>
                    </div>
                </div>
                <ul class="sidebar-menu">

                    <?php if (!$isAdmin): ?>
                        <li class="menu-header">Clinician Profile</li>
                        <li class="dropdown <?php if (strtolower($currentAction) == 'index' || strtolower($currentAction) == 'profile' || strtolower($currentUrl)==="/clinicians") echo 'active"'; ?>"  href="<?= $this->Url->build('/clinician-profile') ?>">
                            <a href="#" class="nav-link has-dropdown"><i data-feather="user"></i><span>My Profile</span></a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a class="nav-link"
                                        <?php if (strtolower($currentAction) == 'profile' || strtolower($currentUrl)==="/clinician-profile") echo 'id="current-page"'; ?>
                                       href="<?= $this->Url->build('/clinician-profile') ?>">
                                        My Details
                                    </a>
                                </li>
                                <li><a class="nav-link" <?php if (strtolower($currentAction) == 'index' && strtolower($currentUrl)==="/clinicians") echo 'id="current-page"'; ?> href="<?= $this->Url->build('/clinicians') ?>">All Clinicians</a></li>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if ($featureVisible('calendar')): ?>

                    <li class="menu-header">Menu</li>

                        <li <?php if (strtolower($currentController) === 'calendar' && strtolower($currentAction) === 'index') echo 'id="current-page"'; ?>>
                            <a class="nav-link" href="<?= $this->Url->build(['controller' => 'Calendar', 'action' => 'index']) ?>">
                                <i data-feather="calendar"></i><span>Calendar</span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if (!empty($isAdmin) && $isAdmin): ?>
                        <li class="menu-header">Admin</li>
                        <li class="dropdown <?php if (strtolower($currentController) === 'clinicianregister' && strtolower($currentAction) === 'index' || strtolower($currentUrl)==="/clinicians") echo 'active'; ?>">
                            <a href="#" class="nav-link has-dropdown"><i data-feather="clipboard"></i><span>Clinicians</span></a>
                            <ul class="dropdown-menu" >
                                <li>
                                    <a class="nav-link" <?php if (strtolower($currentController) === 'clinicianregister') echo 'id="current-page"'; ?> href="<?= $this->Url->build(['controller' => 'ClinicianRegister', 'action' => 'index']) ?>">
                                        Add New Clinician
                                    </a>
                                </li>
                                <li><a class="nav-link" <?php if (strtolower($currentController) === 'clinician' && strtolower($currentUrl)==="/clinicians") echo 'id="current-page"'; ?> href="<?= $this->Url->build('/clinicians') ?>">All Clinicians</a></li>
                            </ul>

                        <li class="dropdown <?php if (strtolower($currentController) === 'clinicianregister' && strtolower($currentAction) === 'index' || strtolower($currentUrl)==="/clinicians") echo 'active'; ?>">
                            <a href="#" class="nav-link has-dropdown"><i data-feather="clipboard"></i><span>Admin</span></a>
                            <ul class="dropdown-menu" >
                                <li><a class="nav-link" <?php if (strtolower($currentAction) == 'profile') echo 'id="current-page"'; ?> href="<?= $this->Url->build('/clinician-profile') ?>">View Admin</a></li>
                                <li>
                                    <a class="nav-link" <?php if (strtolower($currentController) === 'clinicianregister') echo 'id="current-page"'; ?> href="<?= $this->Url->build(['controller' => 'Login', 'action' => 'index']) ?>">
                                        Add New Admin
                                    </a>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if ($featureVisible('participants')): ?>
                        <li class="menu-header">Participants</li>
                        <li class="dropdown <?php if (strtolower($currentController) === 'participants') echo 'active'; ?>">
                            <a href="#" class="nav-link has-dropdown">
                                <i data-feather="users"></i>
                                <span>Participants</span>
                                <?php if ($badgeParticipants > 0): ?>
                                    <span class="badge badge-info" style="margin-left:6px;"><?= $badgeParticipants ?></span>
                                <?php endif; ?>
                            </a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a class="nav-link" <?php if (strtolower($currentController) === 'participants' && strtolower($currentAction)==="add") echo 'id=current-page'; ?> href="<?= $this->Url->build(['controller' => 'Participants', 'action' => 'add']) ?>">
                                        Add New Participant
                                    </a>
                                </li>
                                <li>
                                    <a class="nav-link" <?php if (strtolower($currentController) === 'participants' && strtolower($currentAction)==="index") echo 'id=current-page'; ?> href="<?= $this->Url->build(['controller' => 'Participants', 'action' => 'index']) ?>">
                                        All Participants
                                    </a>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if ($featureVisible('waitlist') && $canWaitlist): ?>
                        <li>
                            <a class="nav-link" <?php if (strtolower($currentController) === 'waitlist') echo 'id="current-page"'; ?>  href="<?= $this->Url->build(['controller'=>'Waitlist','action'=>'index']) ?>">
                                <i data-feather="list"></i><span>Waitlist</span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if ($canBilling && $featureVisible('billing')): ?>

                    <?php if (!empty($isAdmin) && $isAdmin): ?>
                        <li class="menu-header">Business</li>
                    <?php endif; ?>

                        <li>
                            <a class="nav-link" href="<?= $this->Url->build(['controller'=>'Billing','action'=>'index']) ?>">
                                <i data-feather="credit-card"></i><span>Billing</span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if ($canMarketing && $featureVisible('marketing')): ?>
                        <li class="dropdown">
                            <a href="#" class="nav-link has-dropdown"><i data-feather="send"></i><span>Marketing</span></a>
                            <ul class="dropdown-menu">
                                <li><a class="nav-link" href="<?= $this->Url->build("/marketing-contacts") ?>"><span>All Contacts</span></a></li>
                                <li><a class="nav-link" href="<?= $this->Url->build("/marketing-email") ?>"><span>Emailing</span></a></li>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <li class="menu-header">Settings</li>
                    <li class="dropdown">
                        <a href="#" class="nav-link has-dropdown">
                            <i data-feather="settings"></i><span>Settings</span>
                        </a>
                        <ul class="dropdown-menu">
                            <li class="menu-header" style="padding: 6px 16px; text-transform:none; opacity:.7;">Templates</li>
                            <li><a class="nav-link" href="<?= $this->Url->build(['controller'=>'Templates','action'=>'notes']) ?>">Notes</a></li>
                            <li><a class="nav-link" href="<?= $this->Url->build(['controller'=>'Templates','action'=>'reports']) ?>">Reports</a></li>
                            <li><a class="nav-link" href="<?= $this->Url->build(['controller'=>'Templates','action'=>'invoice']) ?>">Invoice</a></li>
                            <li><a class="nav-link" href="<?= $this->Url->build(['controller'=>'Settings','action'=>'index']) ?>">
                                    System Features
                                </a></li>
                        </ul>
                    </li>

                </ul>

            </aside>
        </div>

        <div class="main-content">
            <?= $this->Flash->render() ?>
            <?= $this->fetch('content') ?>

            <div class="settingSidebar">
                <a href="javascript:void(0)" class="settingPanelToggle">
                    <i class="fa fa-spin fa-cog"></i>
                </a>
                <div class="settingSidebar-body ps-container ps-theme-default">
                    <div class="fade show active">
                        <div class="setting-panel-header">Setting Panel</div>

                        <div class="p-15 border-bottom">
                            <h6 class="font-medium m-b-10">Select Layout</h6>
                            <div class="selectgroup layout-color w-50">
                                <label class="selectgroup-item">
                                    <input type="radio" name="value" value="1" class="selectgroup-input select-layout" checked>
                                    <span class="selectgroup-button">Light</span>
                                </label>
                                <label class="selectgroup-item">
                                    <input type="radio" name="value" value="2" class="selectgroup-input select-layout">
                                    <span class="selectgroup-button">Dark</span>
                                </label>
                            </div>
                        </div>

                        <div class="p-15 border-bottom">
                            <h6 class="font-medium m-b-10">Sidebar Color</h6>
                            <div class="selectgroup selectgroup-pills sidebar-color">
                                <label class="selectgroup-item">
                                    <input type="radio" name="icon-input" value="1" class="selectgroup-input select-sidebar">
                                    <span class="selectgroup-button selectgroup-button-icon" data-toggle="tooltip"
                                          data-original-title="Light Sidebar"><i class="fas fa-sun"></i></span>
                                </label>
                                <label class="selectgroup-item">
                                    <input type="radio" name="icon-input" value="2" class="selectgroup-input select-sidebar" checked>
                                    <span class="selectgroup-button selectgroup-button-icon" data-toggle="tooltip"
                                          data-original-title="Dark Sidebar"><i class="fas fa-moon"></i></span>
                                </label>
                            </div>
                        </div>

                        <div class="p-15 border-bottom">
                            <h6 class="font-medium m-b-10">Color Theme</h6>
                            <div class="theme-setting-options">
                                <ul class="choose-theme list-unstyled mb-0">
                                    <li title="white" class="active"><div class="white"></div></li>
                                    <li title="cyan"><div class="cyan"></div></li>
                                    <li title="black"><div class="black"></div></li>
                                    <li title="purple"><div class="purple"></div></li>
                                    <li title="orange"><div class="orange"></div></li>
                                    <li title="green"><div class="green"></div></li>
                                    <li title="red"><div class="red"></div></li>
                                </ul>
                            </div>
                        </div>

                        <div class="p-15 border-bottom">
                            <div class="theme-setting-options">
                                <label>
                                    <span class="control-label p-r-20">Mini Sidebar</span>
                                    <input type="checkbox" name="custom-switch-checkbox" class="custom-switch-input" id="mini_sidebar_setting">
                                    <span class="custom-switch-indicator"></span>
                                </label>
                            </div>
                        </div>

                        <div class="p-15 border-bottom">
                            <div class="theme-setting-options">
                                <div class="disk-server-setting m-b-20">
                                    <p>Disk Space</p>
                                    <div class="sidebar-progress">
                                        <div class="progress" data-height="5">
                                            <div class="progress-bar l-bg-green" role="progressbar" data-width="80%" aria-valuenow="80"
                                                 aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>
                                        <span class="progress-description"><small>26% remaining</small></span>
                                    </div>
                                </div>
                                <div class="disk-server-setting">
                                    <p>Server Load</p>
                                    <div class="sidebar-progress">
                                        <div class="progress" data-height="5">
                                            <div class="progress-bar l-bg-orange" role="progressbar" data-width="58%" aria-valuenow="25"
                                                 aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>
                                        <span class="progress-description"><small>Highly Loaded</small></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-4 mb-4 p-3 align-center rt-sidebar-last-ele">
                            <a href="#" class="btn btn-icon icon-left btn-primary btn-restore-theme">
                                <i class="fas fa-undo"></i> Restore Default
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <footer class="main-footer">
            <div class="footer-right"></div>
        </footer>

    </div>
</div>

<div class="modal fade confirm-modal" id="appConfirm" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header align-items-center">
                <div class="confirm-icon mr-2"><i class="fas fa-exclamation-triangle"></i></div>
                <h5 class="modal-title" id="appConfirmTitle">Please Confirm</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>×</span></button>
            </div>
            <div class="modal-body">
                <p id="appConfirmMsg" class="mb-0">Are you sure?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal" id="appConfirmCancel">Cancel</button>
                <button type="button" class="btn btn-danger" id="appConfirmOk">OK</button>
            </div>
        </div>
    </div>
</div>

<div id="onboardingModal" class="modal fade" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Onboarding</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>×</span></button>
            </div>
            <div id="onboardingModalBody" class="modal-body">
                <div class="text-center p-4">Loading…</div>
            </div>
        </div>
    </div>
</div>



<?= $this->Html->script('/js/app.min.js') ?>
<?= $this->Html->script('/bundles/echart/echarts.js') ?>
<?= $this->Html->script('/bundles/chartjs/chart.min.js') ?>
<?= $this->Html->script('/js/page/index.js') ?>
<?= $this->Html->script('/js/scripts.js') ?>
<?= $this->Html->script('/js/custom.js') ?>

<!-- jQuery UI JS (after jQuery, before your scripts) -->
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

<script>
    $("#participant-search").autocomplete({
        appendTo: ".search-element",
        source: function(request, response) {
            $.ajax({
                url: "<?= $this->Url->build('/participants/search') ?>",
                dataType: "json",
                data: { q: request.term },
                success: function(data) {
                    const items = data.results || [];
                    response(items.map(function(item) {
                        return {
                            label: item.label, // display in dropdown
                            value: item.label, // inserted into input
                            id: item.id       // for redirect
                        };
                    }));
                }
            });
        },
        minLength: 1,
        select: function(event, ui) {
            if (ui.item && ui.item.id) {
                window.location.href = '/team005-app_fit3048/Co-Linic_AI/participants/dashboard/' + ui.item.id;
            }
        },
    });
</script>

<script>
    (function(){
        let targetFormId = null;
        const $modal = $('#appConfirm');
        const $title = $('#appConfirmTitle');
        const $msg   = $('#appConfirmMsg');
        const $ok    = $('#appConfirmOk');
        const $cancel= $('#appConfirmCancel');

        $(document).on('click', '.js-confirm', function(e){
            e.preventDefault();
            const $el = $(this);
            targetFormId = $el.data('form');
            $title.text($el.data('title') || 'Please Confirm');
            $msg.text($el.data('message') || 'Are you sure?');
            $ok.text($el.data('ok-text') || 'OK')
                .removeClass('btn-danger btn-primary btn-warning btn-success')
                .addClass($el.data('ok-class') || 'btn-primary');
            $cancel.text($el.data('cancel-text') || 'Cancel');
            $modal.modal('show');
        });

        $ok.on('click', function(){
            if (targetFormId) {
                const form = document.getElementById(targetFormId);
                if (form) form.submit();
                targetFormId = null;
            }
            $modal.modal('hide');
        });

        $modal.on('hidden.bs.modal', function(){ targetFormId = null; });
    })();
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var trigger = document.getElementById('onboarding-link');
        if (!trigger) return;

        var $modal = $('#onboardingModal');
        var $body  = $('#onboardingModalBody');

        function openOnboardingModal() {
            $body.html('<div class="text-center p-4">Loading…</div>');
            $.ajax({
                url: '<?= $this->Url->build(["controller" => "Onboarding", "action" => "modal"]) ?>',
                method: 'GET',
                headers: { 'X-Requested-With': 'XMLHttpRequest' }
            }).done(function(html){
                $body.html(html);
            }).fail(function(){
                $body.html('<div class="text-danger p-3">Failed to load.</div>');
            });
            $modal.modal('show');
        }

        trigger.addEventListener('click', function(e){
            e.preventDefault();
            openOnboardingModal();
        });
    });
</script>

<script>
    (function () {
        // Note the trailing slash in the built path:
        const COMPLETE_URL_BASE = "<?= $this->Url->build('/onboarding/complete-step/') ?>";

        async function markStepDone(step, btn) {
            btn.disabled = true;
            try {
                const url = COMPLETE_URL_BASE + encodeURIComponent(step); // e.g. /onboarding/complete-step/1
                // Helpful to see exactly what we’re calling:
                // console.log('fetch:', url);

                const res  = await fetch(url, { method: 'GET', headers: { 'Accept': 'application/json' } });
                const text = await res.text();
                if (!res.ok) throw new Error('HTTP ' + res.status + ' ' + text);

                const data = JSON.parse(text);
                if (!data.ok) throw new Error(data.error || 'Failed');

                const bar = document.getElementById('ob-progress-bar');
                const pct = document.getElementById('ob-progress-label');
                if (bar) bar.style.width = data.percent + '%';
                if (pct) pct.textContent = data.percent + '%';

                const navBar = document.querySelector('.navbar .progress-bar');
                const navPct = document.querySelector('.navbar .progress + span, .navbar .ml-2');
                if (navBar) navBar.style.width = data.percent + '%';
                if (navPct) navPct.textContent = data.percent + '%';

                btn.textContent = 'Done';
                btn.classList.remove('btn-success');
                btn.classList.add('btn-secondary');
            } catch (e) {
                alert('Could not mark as done. ' + e.message);
                btn.disabled = false;
            }
        }

        document.addEventListener('click', function (e) {
            const btn = e.target.closest('.js-mark-step');
            if (!btn) return;
            e.preventDefault();
            const step = parseInt(btn.getAttribute('data-step') || '0', 10);
            if (step > 0) markStepDone(step, btn);
        });
    })();
</script>
<?= $this->fetch('scriptBottom') ?>
</body>
</html>
