<?php
/**
 * @var \Cake\Collection\CollectionInterface $featuresAdmin
 * @var \Cake\Collection\CollectionInterface $featuresClin
 * @var array $mapAdmin
 * @var array $mapClinician
 * @var bool $isAdmin
 */
?>
<div class="section">
    <div class="section-header">
        <h1>System Features</h1>
    </div>

    <div class="section-body">
        <?= $this->Form->create(null) ?>

        <?php if ($isAdmin): ?>
            <div class="card mb-4">
                <div class="card-header">
                    <div>
                        <h4 class="mb-0">Admin sidebar visibility</h4>
                        <div class="card-header-form text-muted small">Admins can show/hide all features on the sidebar.</div>
                    </div>
                </div>

                <div class="card-body table-responsive">
                    <table class="table table-striped align-middle">
                        <thead>
                        <tr>
                            <th style="width:30%;">Feature</th>
                            <th style="width:20%;">Admin</th>
                            <th>Description</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($featuresAdmin as $f): ?>
                            <tr>
                                <td>
                                    <strong><?= h($f->label) ?></strong><br>
                                    <span class="text-muted small"><?= h($f->key) ?></span>
                                </td>
                                <td>
                                    <label class="custom-switch mt-2">
                                        <input type="hidden" name="features[admin][<?= h($f->key) ?>]" value="0">
                                        <input type="checkbox" class="custom-switch-input"
                                               name="features[admin][<?= h($f->key) ?>]"
                                               value="1" <?= !empty($mapAdmin[$f->key]) ? 'checked' : '' ?>>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Visible</span>
                                    </label>
                                </td>
                                <td class="text-muted"><?= h($f->description ?? '') ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">
                <div>
                    <h4 class="mb-0">Clinician sidebar visibility</h4>
                    <div class="card-header-form text-muted small">
                        Clinicians can only control Calendar, Participants and Waitlist.
                    </div>
                </div>
            </div>

            <div class="card-body table-responsive">
                <table class="table table-striped align-middle">
                    <thead>
                    <tr>
                        <th style="width:30%;">Feature</th>
                        <th style="width:20%;">Clinician</th>
                        <th>Description</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($featuresClin as $f): ?>
                        <tr>
                            <td>
                                <strong><?= h($f->label) ?></strong><br>
                                <span class="text-muted small"><?= h($f->key) ?></span>
                            </td>
                            <td>
                                <label class="custom-switch mt-2">
                                    <input type="hidden" name="features[clinician][<?= h($f->key) ?>]" value="0">
                                    <input type="checkbox" class="custom-switch-input"
                                           name="features[clinician][<?= h($f->key) ?>]"
                                           value="1" <?= !empty($mapClinician[$f->key]) ? 'checked' : '' ?>>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">Visible</span>
                                </label>
                            </td>
                            <td class="text-muted"><?= h($f->description ?? '') ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <div class="card-footer text-right">
                <button class="btn btn-primary" type="submit">Save</button>
            </div>
        </div>

        <?= $this->Form->end() ?>
    </div>
</div>
