<?php
/** @var \App\Model\Entity\Participant $participant */
/** @var array $clinicians */
/** @var array $relationOptions */
$this->assign('title', 'Register New Participant');
echo $this->Html->css('participants_form');
?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css"/>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@18.5.3/build/css/intlTelInput.css"/>

<section class="section">
    <div class="section-body">
        <div class="row">
            <div class="col-12 col-xl-10 offset-xl-1">

                <?= $this->Form->create($participant, ['novalidate' => true, 'class' => 'needs-validation form-2col']) ?>

                <div class="grid-2col">

                    <div class="block">
                        <div class="block-hd">PATIENT DETAILS</div>
                        <div class="block-bd">
                            <div class="form-row">
                                <div class="col-md-4">
                                    <?= $this->Form->control('first_name', [
                                        'label' => 'Given Name', 'class' => 'form-control', 'required' => true
                                    ]) ?>
                                </div>
                                <div class="col-md-4">
                                    <?= $this->Form->control('middle_name', [
                                        'label' => 'Middle Name', 'class' => 'form-control'
                                    ]) ?>
                                </div>
                                <div class="col-md-4">
                                    <?= $this->Form->control('last_name', [
                                        'label' => 'Surname', 'class' => 'form-control', 'required' => true
                                    ]) ?>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="col-md-6">
                                    <?= $this->Form->control('preferred_name', [
                                        'label' => 'Preferred Name', 'class' => 'form-control'
                                    ]) ?>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="col-md-5">
                                    <?= $this->Form->control('dob', [
                                        'label' => 'Date of Birth',
                                        'type'  => 'date',
                                        'class' => 'form-control',
                                        'max'   => date('Y-m-d'),
                                        'placeholder' => 'DD-MM-YYYY',
                                    ]) ?>
                                </div>

                                <div class="col-md-5">
                                    <?php
                                    $genderOptions = [
                                        ''                 => 'Prefer not to say',
                                        'woman'            => 'Woman',
                                        'man'              => 'Man',
                                        'non-binary'       => 'Non-binary',
                                        'transgender'      => 'Transgender',
                                        'intersex'         => 'Intersex',
                                        'self_described'   => 'Other (self-described)',
                                    ];
                                    ?>
                                    <label class="d-block">Gender</label>
                                    <?= $this->Form->select('gender_select', $genderOptions, [
                                        'empty' => false,
                                        'class' => 'form-control',
                                        'value' => $participant->gender && !isset($genderOptions[$participant->gender]) ? 'self_described' : ($participant->gender ?? ''),
                                    ]) ?>
                                    <div class="mt-2" id="genderOtherWrap" style="<?= ($participant->gender && !isset($genderOptions[$participant->gender])) ? '' : 'display:none' ?>">
                                        <?= $this->Form->text('gender_other', [
                                            'class'       => 'form-control',
                                            'placeholder' => 'Enter self-described gender',
                                            'value'       => (isset($genderOptions[$participant->gender]) ? '' : ($participant->gender ?? '')),
                                        ]) ?>
                                        <small class="text-muted">If selected “Other (self-described)”, this text will be saved.</small>
                                    </div>
                                    <?= $this->Form->hidden('gender', [
                                        'value' => (isset($genderOptions[$participant->gender]) ? ($participant->gender ?? '') : ($participant->gender ?? ''))
                                    ]) ?>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="col-md-5">
                                    <?= $this->Form->control('review_date', [
                                        'label' => 'Review Date',
                                        'type'  => 'date',
                                        'class' => 'form-control',
                                        'placeholder' => 'DD-MM-YYYY',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="block">
                        <div class="block-hd">CONTACT DETAIL</div>
                        <div class="block-bd">
                            <div class="text-muted small mb-2">
                                Add one or more contact details. Each "contact card" contains <strong>Relationship</strong>
                                Telephone number and email address; Configurable <em>Primary</em>。
                            </div>

                            <div id="contactsWrap">
                                <div class="contact-card border rounded p-2 mb-2" data-start="0">
                                    <div class="card-mini-title">Contact 1</div>

                                    <div class="row-head">
                                        <div class="head-selects">
                                            <select class="form-control js-rel" style="min-width:150px">
                                                <option value="self" selected>Self</option>
                                                <option value="parent">Parent</option>
                                                <option value="spouse">Spouse/Partner</option>
                                                <option value="sibling">Sibling</option>
                                                <option value="child">Child</option>
                                                <option value="relative">Relative</option>
                                                <option value="friend">Friend</option>
                                                <option value="guardian">Guardian</option>
                                                <option value="caregiver">Caregiver</option>
                                                <option value="other">Other</option>
                                            </select>
                                        </div>

                                        <div class="spacer"></div>

                                        <div class="row-flags">
                                            <label class="flag">
                                                <input class="form-check-input js-card-primary" type="radio" name="contacts[_primary_index]" value="0" checked>
                                                <span>Primary</span>
                                            </label>
                                            <label class="flag ml-3">
                                                <input class="form-check-input js-card-emergency" type="checkbox">
                                                <span>Emergency</span>
                                            </label>
                                        </div>

                                        <button type="button" class="btn btn-outline-danger btn-sm ml-2 js-card-del">Remove</button>
                                    </div>


                                    <input type="hidden" name="contacts[0][type]" value="phone">
                                    <input type="hidden" name="contacts[0][sort]" value="0">
                                    <input type="hidden" name="contacts[0][label]" class="js-hidden-label-phone" value="self|mobile">
                                    <input type="hidden" name="contacts[0][_delete]" value="0">
                                    <input type="hidden" class="js-phone-hidden" name="contacts[0][value]" value="">
                                    <input type="hidden" name="contacts[0][is_emergency]" class="js-he-phone" value="0">

                                    <input type="hidden" name="contacts[1][type]" value="email">
                                    <input type="hidden" name="contacts[1][sort]" value="10">
                                    <input type="hidden" name="contacts[1][label]" class="js-hidden-label-email" value="self|personal">
                                    <input type="hidden" name="contacts[1][_delete]" value="0">
                                    <input type="hidden" name="contacts[1][is_emergency]" class="js-he-email" value="0">

                                    <div class="row-body">
                                        <div class="body-block mb-3">
                                            <label class="small text-muted d-block mb-1">Phone label</label>
                                            <select class="form-control js-tag-phone" style="min-width:140px">
                                                <option value="mobile" selected>Mobile</option>
                                                <option value="home">Home</option>
                                                <option value="work">Work</option>
                                                <option value="personal">Personal</option>
                                                <option value="other">Other</option>
                                            </select>
                                            <div class="mt-2 phone-input">
                                                <input type="tel" class="form-control js-phone" placeholder="+61 XXX XXX XXX">
                                            </div>
                                        </div>

                                        <div class="body-block">
                                            <label class="small text-muted d-block mb-1">Email label</label>
                                            <select class="form-control js-tag-email" style="min-width:140px">
                                                <option value="personal" selected>Personal</option>
                                                <option value="work">Work</option>
                                                <option value="other">Other</option>
                                            </select>
                                            <div class="mt-2">
                                                <input class="form-control js-email" type="email" name="contacts[1][value]" placeholder="name@example.com">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button type="button" class="btn btn-soft btn-sm js-add-contact">+ Add contact</button>
                            <div class="text-muted small mt-2">Note: If the participant has a guardian or emergency contact person, please select the relationship as
                                <em>Guardian</em>/<em>Parent</em> </div>
                        </div>
                    </div>

                    <div class="block">
                        <div class="block-hd">ASSIGN CLINICIANS</div>
                        <div class="block-bd">
                            <?= $this->Form->select('login._ids', $clinicians, [
                                'multiple' => true, 'class' => 'form-control select2',
                                'data-placeholder' => 'Select one or more clinicians'
                            ]) ?>
                        </div>

                        <div class="block-hd">NOTES</div>
                        <div class="block-bd">
                            <?= $this->Form->control('note', [
                                'type'        => 'textarea',
                                'label'       => false,
                                'rows'        => 4,
                                'placeholder' => 'Add private notes about this participant…',
                                'class'       => 'form-control',
                            ]) ?>
                            <div class="text-muted small mt-1">Visible to staff only.</div>
                        </div>
                    </div>

                    <div class="block">
                        <div class="block-hd">ADDRESS</div>
                        <div class="block-bd" id="addressList">

                            <div class="addr-card" data-index="0">
                                <div class="form-row">
                                    <div class="col-md-6">
                                        <?= $this->Form->control('participant_addresses.0.address_type', [
                                            'label' => 'Address Type', 'type' => 'select',
                                            'options' => ['home'=>'Home','work'=>'Work','other'=>'Other'],
                                            'default' => 'home', 'class' => 'form-control'
                                        ]) ?>
                                    </div>
                                </div>

                                <?= $this->Form->control('participant_addresses.0.address_line1', [
                                    'label' => 'Street Address', 'class' => 'form-control'
                                ]) ?>
                                <div class="mt-2">
                                    <?= $this->Form->control('participant_addresses.0.address_line2', [
                                        'label' => 'Address Line 2', 'class' => 'form-control'
                                    ]) ?>
                                </div>

                                <div class="form-row mt-2">
                                    <div class="col-md-4">
                                        <?= $this->Form->control('participant_addresses.0.city', [
                                            'label' => 'City', 'class' => 'form-control'
                                        ]) ?>
                                    </div>
                                    <div class="col-md-4">
                                        <?php $auStates = ['ACT'=>'ACT','NSW'=>'NSW','NT'=>'NT','QLD'=>'QLD','SA'=>'SA','TAS'=>'TAS','VIC'=>'VIC','WA'=>'WA']; ?>
                                        <?= $this->Form->control('participant_addresses.0.region', [
                                            'label' => 'State / Region', 'type' => 'select',
                                            'options' => $auStates, 'empty' => 'Select State', 'class' => 'form-control'
                                        ]) ?>
                                    </div>
                                    <div class="col-md-4">
                                        <?= $this->Form->control('participant_addresses.0.postcode', [
                                            'label' => 'Postcode', 'class' => 'form-control'
                                        ]) ?>
                                    </div>
                                </div>

                                <div class="form-row mt-2">
                                    <div class="col-md-6">
                                        <?= $this->Form->control('participant_addresses.0.country', [
                                            'label' => 'Country', 'class' => 'form-control', 'value' => 'Australia'
                                        ]) ?>
                                    </div>
                                    <div class="col-md-7">
                                        <?php $tz = [
                                            'Australia/Melbourne'=>'Australia/Melbourne',
                                            'Australia/Sydney'=>'Australia/Sydney',
                                            'Australia/Brisbane'=>'Australia/Brisbane',
                                            'Australia/Perth'=>'Australia/Perth',
                                            'Australia/Adelaide'=>'Australia/Adelaide',
                                            'Australia/Hobart'=>'Australia/Hobart',
                                        ]; ?>
                                        <?= $this->Form->control('participant_addresses.0.time_zone', [
                                            'label' => 'Time Zone', 'type' => 'select',
                                            'options' => $tz, 'empty' => 'Select a time zone', 'class' => 'form-control'
                                        ]) ?>
                                    </div>
                                </div>

                                <button type="button" class="btn btn-link btn-remove-addr" style="display:none">Remove this address</button>
                            </div>

                            <button type="button" class="btn btn-outline-primary btn-sm mt-2" id="btnAddAddress">
                                ADD NEW ADDRESS
                            </button>
                        </div>
                    </div>
                </div>

                <div class="form-actions">
                    <button class="btn btn-primary">Save</button>
                    <a href="<?= $this->Url->build(['action' => 'index']) ?>" class="btn btn-secondary">Cancel</a>
                </div>

                <?= $this->Form->end() ?>

            </div>
        </div>
    </div>
</section>

<style>
    .btn-soft{ background:#eef2ff; color:#4f46e5; border:0; }
    .btn-soft:hover{ background:#e0e7ff; color:#4338ca; }
    .select2-container{ width:100% !important; }
    .contact-card{ padding:12px; background:#fafbff; border:1px solid #e5e7eb; border-radius:10px; }
    .contact-card .row-head{
        display:flex; align-items:center; gap:10px;
        padding-bottom:8px; margin-bottom:10px; border-bottom:1px dashed #e5e7eb;
    }
    .contact-card .spacer{ flex:1; }
    .card-mini-title{ font-weight:600; font-size:13px; color:#6b7280; margin:2px 0 8px; }
    .phone-input .iti{ width:100%; }
    .iti__country-list{ max-width:360px; }
    .block .block-bd .form-row { margin-bottom: 18px; }
    .block .block-bd .form-group { margin-bottom: 16px; }

    .block .block-bd .form-control,
    .flatpickr-input,
    .flatpickr-input ~ .form-control,
    input.hasDatepicker {
        height: 44px;
    }

    .grid-2col { grid-column-gap: 28px; grid-row-gap: 28px; }

    .flatpickr-input[readonly] {
        background-color: #fff;
        cursor: text;
    }

    .block .block-bd label { margin-bottom: 6px; }

    .block .block-bd .form-row + .form-row { margin-top: 10px; }

    .contact-card .row-head{
        display:flex;
        align-items:center;
        flex-wrap:wrap;
        gap:12px 20px;
        padding-bottom:10px;
        margin-bottom:12px;
        border-bottom:1px dashed #e5e7eb;
    }

    .contact-card .head-selects{
        flex:1 1 240px;
        min-width:240px;
    }

    .contact-card .row-flags{
        display:flex;
        align-items:center;
        gap:22px;
        flex:0 0 auto;
        white-space:nowrap;
    }

    .contact-card .flag{
        display:inline-flex;
        align-items:center;
        gap:10px;
        font-weight:500;
        color:#4b5563;
        cursor:pointer;
    }

    .contact-card .flag .form-check-input{
        position: static !important;
        float: none !important;
        margin: 0 !important;
        width: 18px;
        height: 18px;
        transform: none !important;
        vertical-align: middle;
    }

    .contact-card .js-card-del{
        margin-left:auto;
    }

    @media (max-width: 560px){
        .contact-card .row-head{ gap:10px 14px; }
        .contact-card .row-flags{ width:100%; order:2; }
        .contact-card .js-card-del{ order:3; margin-left:0; }
    }

</style>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<?php $this->start('scriptBottom'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@18.5.3/build/js/intlTelInput.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@18.5.3/build/js/utils.js"></script>

<script>
    (function () {
        if (window.jQuery && jQuery.fn && jQuery.fn.select2) {
            jQuery('.select2').select2({ width: '100%' });
        }

        const form = document.querySelector('form.needs-validation');
        if (form) {
            form.addEventListener('submit', function (e) {
                if (!form.checkValidity()) {
                    e.preventDefault();
                    e.stopPropagation();
                }
                form.classList.add('was-validated');
                document.querySelectorAll('.contact-card .js-phone')
                    .forEach(function (ip) { ip.dispatchEvent(new Event('change', { bubbles: true })); });
            }, false);
        }

        function toggleOther() {
            var sel = document.querySelector('[name="emergency_contact_relation"]');
            var grp = document.getElementById('grpRelOther');
            if (!sel || !grp) return;
            grp.style.display = (sel.value === 'other') ? '' : 'none';
            if (sel.value !== 'other') {
                var input = grp.querySelector('input'); if (input) input.value = '';
            }
        }
        var selRel = document.querySelector('[name="emergency_contact_relation"]');
        if (selRel) { selRel.addEventListener('change', toggleOther); toggleOther(); }

        var wrap = document.getElementById('contactsWrap');
        if (!wrap) return;

        function nextStart() {
            var cards = wrap.querySelectorAll('.contact-card');
            if (!cards.length) return 0;
            var last = cards[cards.length - 1];
            return parseInt(last.dataset.start, 10) + 2;
        }

        function optionsHtml(map, selectedKey) {
            var html = '';
            for (var k in map) {
                if (!map.hasOwnProperty(k)) continue;
                html += '<option value="' + k + '"' + (k === selectedKey ? ' selected' : '') + '>' + map[k] + '</option>';
            }
            return html;
        }

        var PHONE_TAGS = { mobile: 'Mobile', home: 'Home', work: 'Work', personal: 'Personal', other: 'Other' };
        var EMAIL_TAGS = { personal: 'Personal', work: 'Work', other: 'Other' };

        function cardTpl(start) {
            var idxPhone = start, idxEmail = start + 1;
            return '' +
                '<div class="contact-card border rounded p-2 mb-2" data-start="' + start + '">' +
                '<div class="card-mini-title js-card-title">Contact</div>' +
                '<div class="row-head">' +
                '<div class="head-selects">' +
                '<select class="form-control js-rel">' +
                '<option value="self">Self</option>' +
                '<option value="parent">Parent</option>' +
                '<option value="spouse">Spouse/Partner</option>' +
                '<option value="sibling">Sibling</option>' +
                '<option value="child">Child</option>' +
                '<option value="relative">Relative</option>' +
                '<option value="friend">Friend</option>' +
                '<option value="guardian">Guardian</option>' +
                '<option value="caregiver">Caregiver</option>' +
                '<option value="other">Other</option>' +
                '</select>' +
                '</div>' +
                '<div class="row-flags">' +
                '<label class="flag">' +
                '<input class="form-check-input js-card-primary" type="radio" name="contacts[_primary_index]" value="' + idxPhone + '">' +
                '<span>Primary</span>' +
                '</label>' +
                '<label class="flag">' +
                '<input class="form-check-input js-card-emergency" type="checkbox">' +
                '<span>Emergency</span>' +
                '</label>' +
                '</div>' +
                '<button type="button" class="btn btn-outline-danger btn-sm js-card-del">Remove</button>' +
                '</div>' +

                '<input type="hidden" name="contacts[' + idxPhone + '][type]" value="phone">' +
                '<input type="hidden" name="contacts[' + idxPhone + '][sort]" value="' + (idxPhone * 10) + '">' +
                '<input type="hidden" name="contacts[' + idxPhone + '][label]" class="js-hidden-label-phone" value="self|mobile">' +
                '<input type="hidden" name="contacts[' + idxPhone + '][_delete]" value="0">' +
                '<input type="hidden" class="js-phone-hidden" name="contacts[' + idxPhone + '][value]" value="">' +
                '<input type="hidden" name="contacts[' + idxPhone + '][is_emergency]" class="js-he-phone" value="0">' +

                '<input type="hidden" name="contacts[' + idxEmail + '][type]" value="email">' +
                '<input type="hidden" name="contacts[' + idxEmail + '][sort]" value="' + (idxEmail * 10) + '">' +
                '<input type="hidden" name="contacts[' + idxEmail + '][label]" class="js-hidden-label-email" value="self|personal">' +
                '<input type="hidden" name="contacts[' + idxEmail + '][_delete]" value="0">' +
                '<input type="hidden" name="contacts[' + idxEmail + '][is_emergency]" class="js-he-email" value="0">' +

                '<div class="row-body">' +
                '<div class="body-block mb-3">' +
                '<label class="small text-muted d-block mb-1">Phone label</label>' +
                '<select class="form-control js-tag-phone" style="min-width:140px">' + optionsHtml(PHONE_TAGS, 'mobile') + '</select>' +
                '<div class="mt-2 phone-input">' +
                '<input type="tel" class="form-control js-phone" placeholder="+61 XXX XXX XXX">' +
                '</div>' +
                '</div>' +
                '<div class="body-block">' +
                '<label class="small text-muted d-block mb-1">Email label</label>' +
                '<select class="form-control js-tag-email" style="min-width:140px">' + optionsHtml(EMAIL_TAGS, 'personal') + '</select>' +
                '<div class="mt-2">' +
                '<input class="form-control js-email" type="email" name="contacts[' + idxEmail + '][value]" placeholder="name@example.com">' +
                '</div>' +
                '</div>' +
                '</div>' +
                '</div>';
        }

        function initPhonePicker(card) {
            var input = card.querySelector('.js-phone');
            var hidden = card.querySelector('.js-phone-hidden');
            if (!input || !hidden || !window.intlTelInput) return;

            var iti = window.intlTelInput(input, {
                initialCountry: 'au',
                separateDialCode: true,
                nationalMode: false,
                utilsScript: 'https://cdn.jsdelivr.net/npm/intl-tel-input@18.5.3/build/js/utils.js'
            });
            input._iti = iti;

            function sync() {
                var e164 = iti.getNumber();
                if (!e164) {
                    var raw = (input.value || '').trim();
                    var dc = '+' + (iti.getSelectedCountryData().dialCode || '');
                    e164 = raw ? (raw[0] === '+' ? raw : (dc + ' ' + raw)) : '';
                }
                hidden.value = e164;
                updatePrimaryValue(card);
            }
            input.addEventListener('change', sync);
            input.addEventListener('blur', sync);
        }

        function syncLabels(card) {
            var rel = (card.querySelector('.js-rel') || {}).value || 'self';
            var pTag = (card.querySelector('.js-tag-phone') || {}).value || 'mobile';
            var eTag = (card.querySelector('.js-tag-email') || {}).value || 'personal';
            var hp = card.querySelector('.js-hidden-label-phone');
            var he = card.querySelector('.js-hidden-label-email');
            if (hp) hp.value = rel + '|' + pTag;
            if (he) he.value = rel + '|' + eTag;
        }

        function updatePrimaryValue(card) {
            var start = parseInt(card.dataset.start, 10);
            var idxPhone = start;
            var idxEmail = start + 1;
            var emailVal = (card.querySelector('.js-email')?.value || '').trim();
            var phoneVal = (card.querySelector('.js-phone-hidden')?.value || '').trim();
            var radio = card.querySelector('.js-card-primary');
            if (!radio) return;
            if (emailVal) { radio.value = idxEmail; }
            else if (phoneVal) { radio.value = idxPhone; }
            else { radio.value = idxPhone; }
        }

        function renumberCards() {
            var cards = [].slice.call(wrap.querySelectorAll('.contact-card'))
                .filter(function (c) { return c.style.display !== 'none' && !c.dataset.deleted; });
            cards.forEach(function (card, i) {
                var t = card.querySelector('.card-mini-title');
                if (t) t.textContent = 'Contact ' + (i + 1);
            });
        }

        function initEmergency(card) {
            var chk = card.querySelector('.js-card-emergency');
            function syncEmergency() {
                var v = (chk && chk.checked) ? '1' : '0';
                var hep = card.querySelector('.js-he-phone');
                var hee = card.querySelector('.js-he-email');
                if (hep) hep.value = v;
                if (hee) hee.value = v;
            }
            if (chk) {
                chk.addEventListener('change', syncEmergency);
                syncEmergency();
            }
        }

        function initCard(card) {
            initPhonePicker(card);
            syncLabels(card);
            updatePrimaryValue(card);
            initEmergency(card);

            ['change', 'input', 'blur'].forEach(function (ev) {
                card.addEventListener(ev, function (e) {
                    if (e.target.matches('.js-rel, .js-tag-phone, .js-tag-email')) syncLabels(card);
                    if (e.target.matches('.js-email')) updatePrimaryValue(card);
                });
            });
        }

        var firstCard = wrap.querySelector('.contact-card');
        if (firstCard) initCard(firstCard);
        renumberCards();

        document.addEventListener('click', function (e) {
            var addBtn = e.target.closest('.js-add-contact');
            if (addBtn) {
                var start = nextStart();
                wrap.insertAdjacentHTML('beforeend', cardTpl(start));
                initCard(wrap.lastElementChild);
                renumberCards();
                return;
            }

            var delBtn = e.target.closest('.js-card-del');
            if (delBtn) {
                var card = delBtn.closest('.contact-card');
                if (!card) return;
                card.remove();
                renumberCards();
            }
        });

        const btnAdd = document.getElementById('btnAddAddress');
        const list = document.getElementById('addressList');
        if (btnAdd && list) {
            btnAdd.addEventListener('click', function () {
                const last = list.querySelector('.addr-card:last-of-type');
                const idx = last ? (parseInt(last.dataset.index, 10) + 1) : 0;
                const tpl = last.cloneNode(true);
                tpl.dataset.index = idx;

                tpl.querySelectorAll('input, select, textarea').forEach(function (el) {
                    el.value = '';
                    el.name = el.name.replace(/participant_addresses\.\d+\./, 'participant_addresses.' + idx + '.');
                });
                tpl.querySelector('.btn-remove-addr').style.display = '';
                list.insertBefore(tpl, btnAdd);

                tpl.querySelector('.btn-remove-addr').addEventListener('click', function () {
                    tpl.remove();
                }, { once: true });
            });
        }

        document.addEventListener('DOMContentLoaded', function () {
            var firstErr = document.querySelector('.error-message, .is-invalid');
            if (firstErr) {
                firstErr.scrollIntoView({ behavior: 'smooth', block: 'center' });
            }
        });
    })();

    (function () {
        var dob = document.querySelector('input[name="dob"]');
        if (dob) {
            var today = new Date().toISOString().slice(0, 10);
            dob.setAttribute('max', today);
        }

        function bindGender(root) {
            var sel = root.querySelector('select[name="gender_select"]');
            var hid = root.querySelector('input[name="gender"]');
            var wrap = root.querySelector('#genderOtherWrap');
            var txt = root.querySelector('input[name="gender_other"]');
            if (!sel || !hid) return;

            function sync() {
                if (sel.value === 'self_described') {
                    wrap && (wrap.style.display = '');
                    if (txt) hid.value = txt.value.trim();
                } else {
                    wrap && (wrap.style.display = 'none');
                    hid.value = sel.value;
                }
            }
            sel.addEventListener('change', sync);
            if (txt) txt.addEventListener('input', sync);
            sync();
        }
        bindGender(document);
    })();

    (function () {
        if (!window.flatpickr) return;
        flatpickr.localize(flatpickr.l10ns.en);

        flatpickr('input[name="dob"]', {
            dateFormat: "Y-m-d",
            altInput: true,
            altFormat: "d-m-Y",
            allowInput: true,
            maxDate: "today"
        });

        flatpickr('input[name="review_date"]', {
            dateFormat: "Y-m-d",
            altInput: true,
            altFormat: "d-m-Y",
            allowInput: true
        });
    })();

    (function () {
        'use strict';
        document.addEventListener('click', function (e) {
            var btn = e.target.closest('.js-show-note');
            if (!btn) return;
            e.preventDefault(); e.stopPropagation();

            var note = btn.getAttribute('data-note') || '';
            var bodyEl = document.getElementById('noteBody');
            if (bodyEl) {
                bodyEl.textContent = note.trim() !== '' ? note : '—';
            }
            if (window.jQuery && window.jQuery.fn && window.jQuery.fn.modal) {
                window.jQuery('#noteModal').modal('show');
            } else {
                var m = document.getElementById('noteModal');
                if (m) m.style.display = 'block';
            }
        });
    })();
</script>

<?php $this->end(); ?>
