<?php
/**
 * File: templates/Onboarding/index.php
 * Var:  $state  \App\Model\Entity\OnboardingState
 */
$done    = (int)$state->step1_done + (int)$state->step2_done + (int)$state->step3_done + (int)$state->step4_done;
$percent = (int)round($done * 25);
?>
<div class="card">
    <div class="card-header"><h4>Get started</h4></div>
    <div class="card-body">
        <div class="progress mb-3">
            <div class="progress-bar" style="width:<?= $percent ?>%"><?= $percent ?>%</div>
        </div>
        <ol>
            <li>
                Set your practice details (name/phone) –
                <?= $state->step1_done ? '✅'
                    : $this->Html->link('Mark done', ['controller' => 'Onboarding', 'action' => 'completeStep', 1]) ?>
            </li>
            <li>
                Add your professional details –
                <?= $state->step2_done ? '✅'
                    : $this->Html->link('Mark done', ['controller' => 'Onboarding', 'action' => 'completeStep', 2]) ?>
            </li>
            <li>
                Set your availability –
                <?= $state->step3_done ? '✅'
                    : $this->Html->link('Mark done', ['controller' => 'Onboarding', 'action' => 'completeStep', 3]) ?>
            </li>
            <li>
                Add first clinician –
                <?= $state->step4_done ? '✅'
                    : $this->Html->link('Mark done', ['controller' => 'Onboarding', 'action' => 'completeStep', 4]) ?>
            </li>
        </ol>

        <?= $this->Html->link(
            'Dismiss',
            ['controller' => 'Onboarding', 'action' => 'dismiss'],
            ['class' => 'btn btn-outline-secondary']
        ) ?>

        <?= $this->Html->link('Show on dashboard again', ['action'=>'undismiss'], ['class'=>'btn btn-light ml-2']) ?>
    </div>
</div>
