<?php $bg = $this->Url->image('login/background.jpg'); ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Welcome!</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />



    <?= $this->Html->css(['app.min', 'style', 'components', 'custom']) ?>
    <?= $this->Html->meta('icon') ?>

    <style>
    </style>

</head>

<body class="login-bg">
<div class="container mt-5" style="max-width:440px">
    <div class="card">
        <div class="card-body p-4">

            <div id="register-form-container">
                <h4 class="mb-3">
                    Register for <span style="color: dodgerblue;">Smart Clinic Flow</span>
                </h4>
                <div class="mb-4 mt-4">Create an Administrator account to manage your clinic.</div>
                <?= $this->Form->create(null, [
                    'id'  => 'register-form',
                    'url' => ['controller' => 'Login', 'action' => 'registerClinic'],
                    'type' => 'post',
                ]) ?>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="first_name">First Name</label>
                        <?= $this->Form->control('first_name', [
                            'type' => 'text',
                            'id' => 'first_name',
                            'label' => false,
                            'class' => 'form-control',
                            'required' => true,
                            'templates' => ['inputContainer' => '{{content}}'],
                        ]) ?>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="last_name">Last Name</label>
                        <?= $this->Form->control('last_name', [
                            'type' => 'text',
                            'id' => 'last_name',
                            'label' => false,
                            'class' => 'form-control',
                            'required' => true,
                            'templates' => ['inputContainer' => '{{content}}'],
                        ]) ?>
                    </div>
                </div>

                <div class="form-group mb-3">
                    <label for="register-email">Email</label>
                    <?= $this->Form->control('email', [
                        'type' => 'email',
                        'id' => 'register-email',
                        'label' => false,
                        'class' => 'form-control',
                        'templates' => ['inputContainer' => '{{content}}'],
                    ]) ?>
                </div>

                <div class="form-group mb-3 row">
                    <div class="col">
                        <label for="register-password">Password</label>
                        <?= $this->Form->control('password', [
                            'type' => 'password',
                            'id' => 'register-password',
                            'label' => false,
                            'class' => 'form-control',
                            'required' => true,
                            'templates' => ['inputContainer' => '{{content}}']
                        ]) ?>
                    </div>
                </div>

                <!--
                <div class="form-group mb-3">
                    <label for="country">Country</label>
                    <?= $this->Form->control('country', [
                    'type' => 'select',
                    'options' => [
                        'AU' => 'Australia',
                        'NZ' => 'New Zealand',
                        'US' => 'United States',
                        'CA' => 'Canada',
                        'GB' => 'United Kingdom',
                        'FR' => 'France',
                        'DE' => 'Germany',
                        'IT' => 'Italy',
                        'ES' => 'Spain',
                        'NL' => 'Netherlands',
                        'CH' => 'Switzerland',
                        'SE' => 'Sweden',
                        'NO' => 'Norway',
                        'JP' => 'Japan',
                        'CN' => 'China',
                        'IN' => 'India',
                        'SG' => 'Singapore',
                        'MY' => 'Malaysia',
                        'TH' => 'Thailand',
                        'BR' => 'Brazil',
                        'AR' => 'Argentina',
                        'MX' => 'Mexico',
                        'ZA' => 'South Africa',
                        'EG' => 'Egypt',
                        'ZW' => 'Zimbabwe',
                    ],
                    'empty' => 'Select your country',
                    'label' => false,
                    'id' => 'country',
                    'class' => 'form-control country-select',
                    'required' => true,
                    'templates' => ['inputContainer' => '{{content}}'],
                ]) ?>
                </div>
                -->



                <div class="form-group mb-2">
                    <?= $this->Form->button('Register', ['class' => 'btn btn-success btn-lg w-100']) ?>
                </div>
                <?= $this->Form->end() ?>
                <hr style="border: none; border-top: 1px solid #ccc; margin: 1em 0;">
                <div class="text-center mt-3">
                    Already registered? <a href="#" id="show-login">Back to Login</a>
                </div>
            </div>

        </div>
    </div>
</div>

<script>
    // Password toggle
    document.addEventListener('click', function (e) {
        const btn = e.target.closest('.password-toggle');
        if (!btn) return;
        const input = document.querySelector(btn.dataset.target);
        if (!input) return;

        const shown = input.type === 'text';
        input.type = shown ? 'password' : 'text';
        btn.setAttribute('aria-label', shown ? 'Show password' : 'Hide password');

        const icon = btn.querySelector('i');
        if (icon) { icon.classList.toggle('fa-eye'); icon.classList.toggle('fa-eye-slash'); }
    }, false);

</script>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.country-select').select2({
            width: '100%',
            placeholder: 'Select a country...',
            dropdownCssClass: 'country-dropdown'
        });
    });
</script>
</body>
</html>
