<?php $bg = $this->Url->image('login/background.jpg'); ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title>Welcome!</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />



    <?= $this->Html->css(['app.min', 'style', 'components', 'custom']) ?>
    <?= $this->Html->meta('icon') ?>

    <style>
        .card { box-shadow: 0 6px 18px rgba(0,0,0,.05); border: 0; border-radius: 12px; }
        .password-wrapper { position: relative; }
        .password-toggle {
            position: absolute; right: 10px; top: 50%; transform: translateY(-50%);
            border: 0; background: transparent; padding: 0 6px; cursor: pointer; color: #6c757d;
        }
        .recaptcha-align { display: flex; justify-content: center; margin-top: .75rem; }
        html, body.login-bg { height: 100%; }
        body.login-bg{
            min-height: 100vh;
            background: url('<?= h($bg) ?>') no-repeat center center fixed;
            background-size: cover;
        }
        body.login-bg::before{
            content: "";
            position: fixed; inset: 0;
            background: radial-gradient(circle at 50% 40%,
            rgba(255,255,255,.70) 0%,
            rgba(255,255,255,.50) 40%,
            rgba(255,255,255,.30) 100%);
            pointer-events: none;
        }
        .card{
            background: rgba(255,255,255,.88);
            backdrop-filter: blur(3px);
            -webkit-backdrop-filter: blur(3px);
        }
        .login-shell{
            min-height: 100vh;
            display: flex; align-items: center; justify-content: center;
        }
        .country-dropdown .select2-results__options {
            max-height: 20em !important; /* Adjust if needed */
            overflow-y: auto;
        }
    </style>

</head>

<body class="login-bg">
<div class="container mt-5" style="max-width:440px">
    <div class="card">
        <div class="card-body p-4">

            <!-- LOGIN FORM -->
            <div id="login-form-container">
                <h4 class="mb-3">
                    Login to <span style="color: dodgerblue;">Smart Clinic Flow</span>
                </h4>
                <?= $this->Flash->render() ?>

                <?= $this->Form->create(null, [
                    'id'          => 'login-form',
                    'url'         => '/',
                    'type'        => 'post',
                    'autocomplete' => 'off',
                ]) ?>

                <?php $this->Form->unlockField('g-recaptcha-response'); ?>

                <div class="form-group mb-3">
                    <label for="email">Email</label>
                    <?= $this->Form->control('email', [
                        'type' => 'email',
                        'id' => 'email',
                        'label' => false,
                        'class' => 'form-control',
                        'autofocus' => true,
                        'templates' => ['inputContainer' => '{{content}}'],
                    ]) ?>
                </div>

                <div class="form-group mb-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <label for="password" class="mb-0">Password</label>
                        <a href="<?= $this->Url->build('/forgot') ?>" class="text-small">Reset Password?</a>
                    </div>

                    <div class="password-wrapper">
                        <?= $this->Form->control('password', [
                            'type' => 'password',
                            'id' => 'password',
                            'label' => false,
                            'class' => 'form-control',
                            'autocomplete' => 'current-password',
                            'templates' => ['inputContainer' => '{{content}}'],
                        ]) ?>
                        <button type="button" class="password-toggle" data-target="#password" aria-label="Show password">
                            <i class="far fa-eye"></i>
                        </button>
                    </div>
                </div>

                <div class="form-group mb-3">
                    <div class="custom-control custom-checkbox">
                        <?= $this->Form->checkbox('remember', [
                            'id' => 'remember-me',
                            'class' => 'custom-control-input',
                            'templates' => ['checkboxContainer' => '{{content}}'],
                        ]) ?>
                        <label class="custom-control-label mb-2" for="remember-me">Remember Me</label>
                    </div>
                </div>

                <script src="https://www.google.com/recaptcha/api.js?hl=en" async defer></script>
                <div class="recaptcha-align">
                    <div class="g-recaptcha" data-sitekey="6Le6pqQrAAAAAD-rDIzxCpNMOyKnpNsDL8bi7eh9"></div>
                </div>


                <div class="form-group mb-2 mt-4">
                    <?= $this->Form->button('Login', ['class' => 'btn btn-primary btn-lg w-100']) ?>
                </div>
                <?= $this->Form->end() ?>
                <hr style="border: none; border-top: 1px solid #ccc; margin: 1em 0;">
                <div class="text-center mt-3">
                    Not registered? <a href="#" id="show-register">Register here</a>
                </div>
            </div>

            <!-- Hidden register form (shows upon user clicking 'Register Here' link-->
            <div id="register-form-container" style="display:none;"> <!-- initially hidden -->
                <h4 class="mb-3">
                    Register for <span style="color: dodgerblue;">Smart Clinic Flow</span>
                </h4>
                <div class="mb-4 mt-4">Create an Administrator account to manage your clinic.</div>
                <?= $this->Form->create(null, [
                    'id'  => 'register-form',
                    'url' => ['controller' => 'Login', 'action' => 'registerClinic'],
                    'type' => 'post',
                ]) ?>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="first_name">First Name</label>
                        <?= $this->Form->control('first_name', [
                            'type' => 'text',
                            'id' => 'first_name',
                            'label' => false,
                            'class' => 'form-control',
                            'required' => true,
                            'templates' => ['inputContainer' => '{{content}}'],
                        ]) ?>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="last_name">Last Name</label>
                        <?= $this->Form->control('last_name', [
                            'type' => 'text',
                            'id' => 'last_name',
                            'label' => false,
                            'class' => 'form-control',
                            'required' => true,
                            'templates' => ['inputContainer' => '{{content}}'],
                        ]) ?>
                    </div>
                </div>

                <div class="form-group mb-3">
                    <label for="register-email">Email</label>
                    <?= $this->Form->control('email', [
                        'type' => 'email',
                        'id' => 'register-email',
                        'label' => false,
                        'class' => 'form-control',
                        'templates' => ['inputContainer' => '{{content}}'],
                    ]) ?>
                </div>

                <div class="form-group mb-3 row">
                    <div class="col">
                        <label for="register-password">Password</label>
                        <?= $this->Form->control('password', [
                            'type' => 'password',
                            'id' => 'register-password',
                            'label' => false,
                            'class' => 'form-control',
                            'required' => true,
                            'templates' => ['inputContainer' => '{{content}}']
                        ]) ?>
                    </div>
                </div>

                <!--
                <div class="form-group mb-3">
                    <label for="country">Country</label>
                    <?= $this->Form->control('country', [
                                    'type' => 'select',
                                    'options' => [
                                        'AU' => 'Australia',
                                        'NZ' => 'New Zealand',
                                        'US' => 'United States',
                                        'CA' => 'Canada',
                                        'GB' => 'United Kingdom',
                                        'FR' => 'France',
                                        'DE' => 'Germany',
                                        'IT' => 'Italy',
                                        'ES' => 'Spain',
                                        'NL' => 'Netherlands',
                                        'CH' => 'Switzerland',
                                        'SE' => 'Sweden',
                                        'NO' => 'Norway',
                                        'JP' => 'Japan',
                                        'CN' => 'China',
                                        'IN' => 'India',
                                        'SG' => 'Singapore',
                                        'MY' => 'Malaysia',
                                        'TH' => 'Thailand',
                                        'BR' => 'Brazil',
                                        'AR' => 'Argentina',
                                        'MX' => 'Mexico',
                                        'ZA' => 'South Africa',
                                        'EG' => 'Egypt',
                                        'ZW' => 'Zimbabwe',
                                    ],
                                    'empty' => 'Select your country',
                                    'label' => false,
                                    'id' => 'country',
                                    'class' => 'form-control country-select',
                                    'required' => true,
                                    'templates' => ['inputContainer' => '{{content}}'],
                                ]) ?>
                </div>
                -->



                <div class="form-group mb-2">
                    <?= $this->Form->button('Register', ['class' => 'btn btn-success btn-lg w-100']) ?>
                </div>
                <?= $this->Form->end() ?>
                <hr style="border: none; border-top: 1px solid #ccc; margin: 1em 0;">
                <div class="text-center mt-3">
                    Already registered? <a href="#" id="show-login">Back to Login</a>
                </div>
            </div>

        </div>
    </div>
</div>

<script>
    // Toggle forms
    document.getElementById("show-register").addEventListener("click", function(e) {
        e.preventDefault();
        document.getElementById("login-form-container").style.display = "none";
        document.getElementById("register-form-container").style.display = "block";
    });

    document.getElementById("show-login").addEventListener("click", function(e) {
        e.preventDefault();
        document.getElementById("register-form-container").style.display = "none";
        document.getElementById("login-form-container").style.display = "block";
    });

    // Password toggle
    document.addEventListener('click', function (e) {
        const btn = e.target.closest('.password-toggle');
        if (!btn) return;
        const input = document.querySelector(btn.dataset.target);
        if (!input) return;

        const shown = input.type === 'text';
        input.type = shown ? 'password' : 'text';
        btn.setAttribute('aria-label', shown ? 'Show password' : 'Hide password');

        const icon = btn.querySelector('i');
        if (icon) { icon.classList.toggle('fa-eye'); icon.classList.toggle('fa-eye-slash'); }
    }, false);

</script>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.country-select').select2({
            width: '100%',
            placeholder: 'Select a country...',
            dropdownCssClass: 'country-dropdown'
        });
    });
</script>
</body>
</html>
