<?php
/** @var \App\Model\Entity\Login $clinician */
/** @var \App\Model\Entity\Login $specializations */

$this->assign('title', 'Edit Clinician');
$queryParams = $this->request->getQueryParams();

?>

<section class="section">
    <div class="section-body">
        <div class="row">
            <div class="col-12 col-lg-10 offset-lg-1">
                <div class="card">
                    <?= $this->Flash->render() ?>
                    <div class="card-header">
                        <h4>Edit <?= ucfirst($clinician->role ?? 'User') ?></h4>
                    </div>

                    <div class="card-body">
                        <?= $this->Form->create($clinician, [
                            'novalidate' => true,
                            'class'      => 'needs-validation',
                            'url'        => [
                                'action' => 'edit',
                                $clinician->id,
                                '?'      => $queryParams,
                            ],
                        ]) ?>

                        <div class="row">
                            <div class="form-group col-md-6">
                                <?= $this->Form->control('first_name', [
                                    'label' => 'First Name',
                                    'class' => 'form-control',
                                    'required' => true
                                ]) ?>
                            </div>
                            <div class="form-group col-md-6">
                                <?= $this->Form->control('last_name', [
                                    'label' => 'Last Name',
                                    'class' => 'form-control'
                                ]) ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-6">
                                <?= $this->Form->control('email', [
                                    'label' => 'Email',
                                    'type'  => 'email',
                                    'class' => 'form-control',
                                    'required' => true
                                ]) ?>
                            </div>
                            <div class="form-group col-md-6">
                                <?= $this->Form->control('mobile_phone', [
                                    'label'       => 'Phone',
                                    'class'       => 'form-control',
                                    'placeholder' => '+61 xxx xxx xxx',
                                    'pattern'     => '^\+?\d[\d\s-]{7,15}$'
                                ]) ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <?= $this->Form->label('specializations._ids', 'Assign Specializations') ?>

                            <?= $this->Form->select('specializations._ids', $specializations, [
                                'multiple'         => true,
                                'class'            => 'form-control select2',
                                'data-placeholder' => 'Select one or more specializations',
                                'size'             => 6,
                                'value'          => $preSelectedIds ?? null,
                            ]) ?>

                            <small class="form-text text-muted">You can choose multiple specializations.</small>
                        </div>

                        <hr class="my-4">

                        <h5 class="mb-3">Emergency Contact (optional)</h5>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <?= $this->Form->control('emergency_name', [
                                    'label' => 'Name',
                                    'class' => 'form-control',
                                    'required' => false
                                ]) ?>
                            </div>
                            <div class="form-group col-md-6">
                                <?= $this->Form->control('emergency_email', [
                                    'label' => 'Email',
                                    'type'  => 'email',
                                    'class' => 'form-control',
                                    'required' => false
                                ]) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <?= $this->Form->control('emergency_phone', [
                                    'label' => 'Phone',
                                    'class' => 'form-control',
                                    'placeholder' => '+61 xxx xxx xxx',
                                    'required' => false
                                ]) ?>
                            </div>
                        </div>

                        <div class="form-group mb-0">
                            <?= $this->Form->button('Save', ['class' => 'btn btn-primary']) ?>

                            <a href="<?= $this->Url->build($backUrl ?? ['controller'=>'Clinician','action'=>'profile']) ?>"
                               class="btn btn-secondary">
                                Cancel
                            </a>
                        </div>

                        <?= $this->Form->end() ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $this->start('css'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css"/>
<?php $this->end(); ?>

<?php $this->start('scriptBottom'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.full.min.js"></script>
<script>
    (function () {
        if (window.jQuery) {
            $('.select2').select2({
                width: '100%',
                placeholder: function(){
                    return $(this).data('placeholder') || 'Select…';
                },
                allowClear: true
            });
        }

        const form = document.querySelector('form.needs-validation');
        if (form){
            form.addEventListener('submit', function (e) {
                if (!form.checkValidity()) { e.preventDefault(); e.stopPropagation(); }
                form.classList.add('was-validated');
            }, false);
        }
    })();
        var sel = document.querySelector('[name="specializations._ids"]');
        if (sel && !sel.id) sel.id = 'specializations._ids';
        if (sel) {
            sel.addEventListener('change', toggleOther);
            toggleOther();
        }
    })();
</script>
<?php $this->end(); ?>
