<?php
$this->assign('title', 'Calendar');
/** @var array $clinicians */

$cfg = [
    'FEED'   => $this->Url->build(['controller'=>'Calendar','action'=>'events','_ext'=>'json']),
    'STORE'  => $this->Url->build(['controller'=>'Calendar','action'=>'store','_ext'=>'json']),
    'MOVE'   => rtrim($this->Url->build(['controller'=>'Calendar','action'=>'move']), '/'),
    'STATUS' => rtrim($this->Url->build(['controller'=>'Calendar','action'=>'status','_ext'=>'json']), '/'),
    'CLIN'   => $this->Url->build(['controller'=>'Calendar','action'=>'clinicians','_ext'=>'json']),
    'UPDATE' => rtrim($this->Url->build(['controller'=>'Calendar','action'=>'update']), '/'),
    'DELETE' => rtrim($this->Url->build(['controller'=>'Calendar','action'=>'delete']), '/'),
    'SRV_FEED' => $this->Url->build(['controller'=>'Services','action'=>'search','_ext'=>'json']),
    'SRV_ADD'  => $this->Url->build(['controller'=>'Services','action'=>'add','_ext'=>'json']),
    'PARTS'  => $this->Url->build(['controller'=>'Participants','action'=>'suggest','_ext'=>'json']),
    'PART_CREATE' => $this->Url->build(['controller'=>'Participants','action'=>'add','_ext'=>'json']),
    'PART_ADDR' => $this->Url->build(['controller'=>'Participants','action'=>'locations','_ext'=>'json']),
    'WL_FEED'  => $this->Url->build(['controller'=>'Waitlist','action'=>'feed','_ext'=>'json']),
    'WL_ADD'   => $this->Url->build(['controller'=>'Waitlist','action'=>'add','_ext'=>'json']),
    'WL_MARK'  => rtrim($this->Url->build(['controller'=>'Waitlist','action'=>'markScheduled']), '/'),
    'REM_SCHEDULE' => $this->Url->build(['controller'=>'Reminders','action'=>'schedule','_ext'=>'json']),
    'REM_CANCEL'   => $this->Url->build(['controller'=>'Reminders','action'=>'cancel','_ext'=>'json']),
    'REM_RESYNC'   => $this->Url->build(['controller'=>'Reminders','action'=>'resync','_ext'=>'json']),
    'REM_SEND_NOW' => $this->Url->build(['controller'=>'Reminders','action'=>'sendNow','_ext'=>'json']),
    'PART_CONTACTS' => $this->Url->build(['controller'=>'Participants','action'=>'contacts','_ext'=>'json']),
    'CSRF'   => $this->request->getAttribute('csrfToken'),
];
?>
<?= $this->Flash->render() ?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css">
<?= $this->Html->css('calendar', ['block'=>true]) ?>

<section class="section">
    <div class="section-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header" style="align-items:center;gap:12px;">
                        <h4 class="mb-0">Calendar</h4>
                        <div class="ml-auto" style="display:flex;align-items:center;gap:8px;">
                            <label for="clinician" class="mb-0">Clinician</label>
                            <select id="clinician" class="form-control" style="min-width:220px"><option value="">All</option></select>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="calendar"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="modal fade" id="createEventModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document"><div class="modal-content">
            <div class="modal-header align-items-center">
                <h5 class="modal-title mr-3">New Appointment</h5>
                <div class="btn-group btn-group-sm" role="group" aria-label="Appointment sections">
                    <button type="button" id="btnTabDetails" class="btn btn-outline-primary active">Details</button>
                    <button type="button" id="btnTabNote" class="btn btn-outline-primary">Clinical note</button>
                </div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>×</span></button>
            </div>

            <div class="modal-body">
                <form id="evtForm" novalidate>
                    <datalist id="participantsDatalist"></datalist>

                    <div id="evtStep1" class="wizard-step">
                        <div class="form-group">
                            <label for="evtTitle">Participant / Title</label>
                            <input type="text" class="form-control" id="evtTitle" list="participantsDatalist"
                                   placeholder="Type a participant name or any title…" autocomplete="off" required>
                            <small id="titleQuickAdd" class="form-text" style="display:none;">
                                <a href="#" id="lnkQuickAdd"></a>
                            </small>
                            <small class="form-text text-muted">
                                You can <a href="#" id="lnkCreateParticipant">create a new participant</a>
                                or <a href="#" id="lnkSelectFromWL">select from wait list</a>.
                            </small>
                        </div>

<!--                        <div class="form-group">-->
<!--                            <label for="evtServiceType">Service Type</label>-->
<!--                            <select class="form-control" id="evtServiceType">-->
<!--                                <option value="">Select a service type</option>-->
<!--                                <option value="assessment">Assessment</option>-->
<!--                                <option value="therapy">Therapy</option>-->
<!--                                <option value="consultation">Consultation</option>-->
<!--                                <option value="follow_up">Follow-up</option>-->
<!--                            </select>-->
<!--                            <small class="form-text text-muted">-->
<!--                                Used for reporting/colour tagging. You can extend this list later.-->
<!--                            </small>-->
<!--                        </div>-->


                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="evtDate">Date</label>
                                <input type="date" class="form-control" id="evtDate" required>
                            </div>
                            <div class="form-group col-md-3">
                                <label for="evtStart">Start</label>
                                <input type="time" class="form-control" id="evtStart" value="09:00" required>
                            </div>
                            <div class="form-group col-md-3">
                                <label for="evtEnd">End</label>
                                <input type="time" class="form-control" id="evtEnd" value="09:30">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="evtClinician">Clinician</label>
                                <select class="form-control" id="evtClinician"><option value="">Unassigned</option></select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="evtStatus">Status</label>
                                <select class="form-control" id="evtStatus">
                                    <option value="pending">Pending</option>
                                    <option value="confirmed">Confirmed</option>
                                    <option value="cancelled">Cancelled</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="evtLocation">Location</label>
                            <select id="evtLocation" class="form-control select2" data-placeholder="Search or pick a location…"></select>
                            <small class="form-text text-muted">Type to search. Pick <em>Other address</em> to add a new one.</small>
                        </div>

                        <div class="form-group">
                            <label for="evtContact">Contact</label>
                            <input type="text" class="form-control" id="evtContact" placeholder="Email or phone…">
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="evtReminder">Reminder</label>
                                <select id="evtReminder" class="form-control">
                                    <option value="off">Off (no reminder)</option>
                                    <option value="0">At start time</option>
                                    <option value="15">15 minutes before</option>
                                    <option value="30">30 minutes before</option>
                                    <option value="60">1 hour before</option>
                                    <option value="120">2 hours before</option>
                                    <option value="1440">1 day before</option>
                                </select>
                                <small class="text-muted">Will be sent to the email in “Contact”.</small>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="evtReminderTpl">Reminder template</label>
                                <select id="evtReminderTpl" class="form-control">
                                    <option value="default">Default</option>
                                    <option value="short">Short</option>
                                </select>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between align-items-center">
                            <a href="#" id="lnkAddToWL">Add to wait list</a>
                        </div>
                    </div>

                    <div id="evtStep2" class="wizard-step" style="display:none;">
                        <div class="card">
                            <div class="card-header d-flex align-items-center" style="gap:8px;">
                                <strong class="mr-2 mb-0">Clinical note</strong>
                                <select id="noteTpl" class="form-control form-control-sm" style="max-width:260px;">
                                    <option value="">Select a template (optional)</option>
                                    <option value="generic">SOAP</option>
                                    <option value="brief">Brief record</option>
                                </select>
                            </div>
                            <div class="card-body">
                                <textarea class="form-control" id="noteBody" rows="10" placeholder="Start inputting the medical visit records..."></textarea>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="text-danger small" id="evtError" style="display:none;"></div>
            </div>

            <div class="modal-footer">
                <button type="button" id="btnDeleteEvent" class="btn btn-outline-danger">Delete</button>
                <button type="button" id="btnUpdateEvent" class="btn btn-primary">Save</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            </div>
        </div></div>
</div>

<?php $this->start('scriptBottom'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/material_blue.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/locales-all.min.js"></script>
<script>window.__CAL_CFG__ = <?= json_encode($cfg, JSON_UNESCAPED_SLASHES) ?>;</script>

<script>
    (function() {
        if (!window.echarts) return;
        try {
            const orig = window.echarts.init;
            window.echarts.init = new Proxy(orig, {
                apply(target, thisArg, args) {
                    const el = args && args[0];
                    if (!el || !el.nodeType) {
                        return { setOption(){}, resize(){}, dispose(){} };
                    }
                    return Reflect.apply(target, thisArg, args);
                }
            });
        } catch (_) {}
    })();
    (function($){
        if (!$ || !$.fn.select2) return;
        $(document).on('shown.bs.modal', '#participantModal', function () {
            var $dlg = $(this), $host = $dlg.find('.modal-content');
            $dlg.find('.modal-content').css('overflow','visible');
            $dlg.find('select.select2').each(function(){
                var $sel=$(this); try{$sel.select2('destroy');}catch(e){}
                $sel.select2({ width:'100%', dropdownParent:$host, placeholder:$sel.data('placeholder')||'', allowClear:true, closeOnSelect:!$sel.prop('multiple') });
            });
        });
    })(jQuery);
</script>

<?= $this->Html->script('calendar') ?>
<?php $this->end(); ?>
