<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * OnboardingStates Model
 *
 * @property \App\Model\Table\ClinicsTable&\Cake\ORM\Association\BelongsTo $Clinics
 *
 * @method \App\Model\Entity\OnboardingState newEmptyEntity()
 * @method \App\Model\Entity\OnboardingState newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\OnboardingState> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\OnboardingState get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\OnboardingState findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\OnboardingState patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\OnboardingState> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\OnboardingState|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\OnboardingState saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\OnboardingState>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\OnboardingState>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\OnboardingState>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\OnboardingState> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\OnboardingState>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\OnboardingState>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\OnboardingState>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\OnboardingState> deleteManyOrFail(iterable $entities, array $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class OnboardingStatesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('onboarding_states');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Clinics', [
            'foreignKey' => 'clinic_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('clinic_id')
            ->notEmptyString('clinic_id')
            ->add('clinic_id', 'unique', ['rule' => 'validateUnique', 'provider' => 'table']);

        $validator
            ->integer('owner_login_id')
            ->requirePresence('owner_login_id', 'create')
            ->notEmptyString('owner_login_id');

        $validator
            ->boolean('step1_done')
            ->allowEmptyString('step1_done');

        $validator
            ->boolean('step2_done')
            ->allowEmptyString('step2_done');

        $validator
            ->boolean('step3_done')
            ->allowEmptyString('step3_done');

        $validator
            ->boolean('step4_done')
            ->allowEmptyString('step4_done');

        $validator
            ->boolean('dismissed')
            ->allowEmptyString('dismissed');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->isUnique(['clinic_id']), ['errorField' => 'clinic_id']);
        $rules->add($rules->existsIn(['clinic_id'], 'Clinics'), ['errorField' => 'clinic_id']);

        return $rules;
    }
}
