<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Clinics Model
 *
 * @property \App\Model\Table\OnboardingStatesTable&\Cake\ORM\Association\HasOne $OnboardingStates
 * @property \App\Model\Table\ClinicUsersTable&\Cake\ORM\Association\HasMany $ClinicUsers
 *
 * @method \App\Model\Entity\Clinic newEmptyEntity()
 * @method \App\Model\Entity\Clinic newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Clinic> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Clinic get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Clinic findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Clinic patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Clinic> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Clinic|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Clinic saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Clinic>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Clinic>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Clinic>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Clinic> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Clinic>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Clinic>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Clinic>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Clinic> deleteManyOrFail(iterable $entities, array $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class ClinicsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('clinics');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->hasOne('OnboardingStates', [
            'foreignKey' => 'clinic_id',
        ]);
        $this->hasMany('ClinicUsers', [
            'foreignKey' => 'clinic_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('name')
            ->maxLength('name', 120)
            ->requirePresence('name', 'create')
            ->notEmptyString('name');

        $validator
            ->scalar('timezone')
            ->maxLength('timezone', 64)
            ->allowEmptyString('timezone');

        $validator
            ->scalar('business_phone')
            ->maxLength('business_phone', 32)
            ->allowEmptyString('business_phone');

        $validator
            ->scalar('address_json')
            ->maxLength('address_json', 4294967295)
            ->allowEmptyString('address_json');

        return $validator;
    }
}
