<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * CliniciansSpecializations Model
 *
 * @property \App\Model\Table\LoginsTable&\Cake\ORM\Association\BelongsTo $Logins
 * @property \App\Model\Table\SpecializationsTable&\Cake\ORM\Association\BelongsTo $Specializations
 *
 * @method \App\Model\Entity\CliniciansSpecialization newEmptyEntity()
 * @method \App\Model\Entity\CliniciansSpecialization newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\CliniciansSpecialization> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\CliniciansSpecialization get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\CliniciansSpecialization findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\CliniciansSpecialization patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\CliniciansSpecialization> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\CliniciansSpecialization|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\CliniciansSpecialization saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\CliniciansSpecialization>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\CliniciansSpecialization>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\CliniciansSpecialization>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\CliniciansSpecialization> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\CliniciansSpecialization>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\CliniciansSpecialization>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\CliniciansSpecialization>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\CliniciansSpecialization> deleteManyOrFail(iterable $entities, array $options = [])
 */
class CliniciansSpecializationsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('clinicians_specializations');
        $this->setDisplayField(['login_id', 'specialization_id']);
        $this->setPrimaryKey(['login_id', 'specialization_id']);

        $this->belongsTo('Logins', [
            'foreignKey' => 'login_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Specializations', [
            'foreignKey' => 'specialization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['login_id'], 'Logins'), ['errorField' => 'login_id']);
        $rules->add($rules->existsIn(['specialization_id'], 'Specializations'), ['errorField' => 'specialization_id']);

        return $rules;
    }
}
