<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * OnboardingState Entity
 *
 * @property int $id
 * @property int $clinic_id
 * @property int $owner_login_id
 * @property bool|null $step1_done
 * @property bool|null $step2_done
 * @property bool|null $step3_done
 * @property bool|null $step4_done
 * @property bool|null $dismissed
 * @property \Cake\I18n\DateTime|null $created
 * @property \Cake\I18n\DateTime|null $modified
 *
 * @property \App\Model\Entity\Clinic $clinic
 */
class OnboardingState extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'clinic_id' => true,
        'owner_login_id' => true,
        'step1_done' => true,
        'step2_done' => true,
        'step3_done' => true,
        'step4_done' => true,
        'dismissed' => true,
        'created' => true,
        'modified' => true,
        'clinic' => true,
    ];
}
