<?php
declare(strict_types=1);

namespace App\Controller;

class SettingsController extends AppController
{
    private \Cake\ORM\Table $RoleFeatureSettings;

    // Clinician 允许控制的 key 白名单
    private const CLINICIAN_ALLOWED_KEYS = ['calendar', 'participants', 'waitlist'];

    public function initialize(): void
    {
        parent::initialize();
        $this->RoleFeatureSettings = $this->fetchTable('RoleFeatureSettings');
    }

    public function index()
    {
        $identity = $this->request->getAttribute('identity');
        $role     = strtolower((string)($identity->get('role') ?? 'clinician'));
        $isAdmin  = ($role === 'admin');

        $Features     = $this->fetchTable('Features');
        $RoleSettings = $this->RoleFeatureSettings;

        if ($this->request->is(['post','put','patch'])) {
            $payload = (array)$this->request->getData('features', []);
            $ok = true;

            // Admin 可存全部
            if ($isAdmin && isset($payload['admin'])) {
                $ok = $ok && $RoleSettings->saveVisibilityForRole('admin', (array)$payload['admin']);
            }

            // Clinician 仅允许白名单 key
            if (isset($payload['clinician'])) {
                $cli = (array)$payload['clinician'];
                $cli = array_intersect_key(
                    $cli,
                    array_flip(self::CLINICIAN_ALLOWED_KEYS)
                );
                $ok = $ok && $RoleSettings->saveVisibilityForRole('clinician', $cli);
            }

            if ($ok) {
                $this->Flash->success('Saved.');
            } else {
                $this->Flash->error('Save failed.');
            }
            return $this->redirect(['action' => 'index']);
        }

        // 读取所有 feature
        $featuresAll   = $Features->find('all')->orderByAsc('label')->all();

        // 分别给两个表格的数据源
        $featuresAdmin = $featuresAll; // 全部
        $featuresClin  = $featuresAll->filter(function($f){
            return in_array($f->key, self::CLINICIAN_ALLOWED_KEYS, true);
        });

        // 当前可见性映射
        $mapAdmin     = $this->RoleFeatureSettings->getVisibleMapForRole('admin');
        $mapClinician = $this->RoleFeatureSettings->getVisibleMapForRole('clinician');

        $this->set(compact(
            'featuresAdmin',
            'featuresClin',
            'mapAdmin',
            'mapClinician',
            'isAdmin'
        ));
    }
}
